/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.messaging.container;

import com.microsoft.azure.spring.messaging.container.MessageListenerContainer;
import com.microsoft.azure.spring.messaging.listener.AzureMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;

abstract class AbstractListenerContainer
implements BeanNameAware,
DisposableBean,
MessageListenerContainer {
    private static final Logger log = LoggerFactory.getLogger(AbstractListenerContainer.class);
    private final Object lifecycleMonitor = new Object();
    private String destination;
    private String group;
    private AzureMessageHandler messageHandler;
    private boolean autoStartup = true;
    private int phase = 0;
    private boolean active;
    private boolean running;
    private String beanName;

    AbstractListenerContainer() {
    }

    protected abstract void doStart();

    protected abstract void doStop();

    protected void doDestroy() {
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        log.debug("Starting container with name {}", (Object)this.getBeanName());
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            this.running = true;
            this.getLifecycleMonitor().notifyAll();
        }
        this.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        log.debug("Stopping container with name {}", (Object)this.getBeanName());
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            this.running = false;
            this.getLifecycleMonitor().notifyAll();
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.getLifecycleMonitor();
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            this.active = false;
            this.doDestroy();
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Object getLifecycleMonitor() {
        return this.lifecycleMonitor;
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    public int getPhase() {
        return this.phase;
    }

    @Override
    public AzureMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Override
    public void setMessageHandler(AzureMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }
}

