/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.feature.manager;

import com.microsoft.azure.spring.cloud.feature.manager.FeatureGate;
import com.microsoft.azure.spring.cloud.feature.manager.FeatureManager;
import com.microsoft.azure.spring.cloud.feature.manager.FeatureManagerSnapshot;
import com.microsoft.azure.spring.cloud.feature.manager.IDisabledFeaturesHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import reactor.core.publisher.Mono;

@Component
public class FeatureHandler
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureHandler.class);
    private FeatureManager featureManager;
    private FeatureManagerSnapshot featureManagerSnapshot;
    private IDisabledFeaturesHandler disabledFeaturesHandler;

    public FeatureHandler(FeatureManager featureManager, FeatureManagerSnapshot featureManagerSnapshot, IDisabledFeaturesHandler disabledFeaturesHandler) {
        this.featureManager = featureManager;
        this.featureManagerSnapshot = featureManagerSnapshot;
        this.disabledFeaturesHandler = disabledFeaturesHandler;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        FeatureGate featureOn;
        Method method = null;
        if (handler instanceof HandlerMethod) {
            method = ((HandlerMethod)handler).getMethod();
        }
        if (method != null && (featureOn = method.getAnnotation(FeatureGate.class)) != null) {
            String feature = featureOn.feature();
            boolean snapshot = featureOn.snapshot();
            Mono<Boolean> enabled = !snapshot ? this.featureManager.isEnabledAsync(feature) : this.featureManagerSnapshot.isEnabledAsync(feature);
            boolean isEnabled = false;
            try {
                isEnabled = Optional.ofNullable(enabled).map(Mono::block).orElse(false);
                if (!isEnabled && !featureOn.fallback().isEmpty()) {
                    response.sendRedirect(featureOn.fallback());
                }
            }
            catch (IOException e) {
                LOGGER.info("Unable to send redirect.");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            if (!isEnabled && this.disabledFeaturesHandler != null) {
                this.disabledFeaturesHandler.handleDisabledFeatures(request, response);
            } else if (!isEnabled) {
                try {
                    response.sendError(404);
                }
                catch (IOException e) {
                    LOGGER.error("Error thrown while returning 404 on false feature.", (Throwable)e);
                    return false;
                }
            }
            return isEnabled;
        }
        return true;
    }
}

