/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.resource;

import com.microsoft.azure.spring.cloud.config.resource.ConnectionString;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConnectionStringPool {
    private Map<String, ConnectionString> connectionStringMap = new ConcurrentHashMap<String, ConnectionString>();

    public void put(String endpoint, ConnectionString connectionString) {
        Assert.hasText((String)endpoint, (String)"Config store endpoint cannot be null or empty.");
        Assert.notNull((Object)connectionString, (String)"Connection string should not be null.");
        this.connectionStringMap.put(endpoint, connectionString);
    }

    public void put(String endpoint, String connectionString) {
        this.put(endpoint, ConnectionString.of(connectionString));
    }

    @Nullable
    public ConnectionString get(String endpoint) {
        return this.connectionStringMap.get(endpoint);
    }

    public Map<String, ConnectionString> getAll() {
        return this.connectionStringMap;
    }
}

