/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class ConnectionString {
    private static final String CONN_STRING_REGEXP = "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)";
    public static final String ENDPOINT_ERR_MSG = String.format("Connection string does not follow format %s.", "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    private static final Pattern CONN_STRING_PATTERN = Pattern.compile("Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    public static final String NON_EMPTY_MSG = "%s property should not be null or empty in the connection string of Azure Config Service.";
    private final String endpoint;
    private final String id;
    private final String secret;

    private ConnectionString(String endpoint, String id, String secret) {
        this.endpoint = endpoint;
        this.id = id;
        this.secret = secret;
    }

    public static ConnectionString of(String connectionString) {
        Assert.hasText((String)connectionString, (String)String.format("Connection string cannot be empty.", new Object[0]));
        Matcher matcher = CONN_STRING_PATTERN.matcher(connectionString);
        if (!matcher.find()) {
            throw new IllegalStateException(ENDPOINT_ERR_MSG);
        }
        String endpoint = matcher.group(1);
        String id = matcher.group(2);
        String secret = matcher.group(3);
        Assert.hasText((String)endpoint, (String)String.format(NON_EMPTY_MSG, "Endpoint"));
        Assert.hasText((String)id, (String)String.format(NON_EMPTY_MSG, "Id"));
        Assert.hasText((String)secret, (String)String.format(NON_EMPTY_MSG, "Secret"));
        return new ConnectionString(endpoint, id, secret);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getId() {
        return this.id;
    }

    public String getSecret() {
        return this.secret;
    }
}

