/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.managed.identity;

import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.resources.GenericResource;
import com.microsoft.azure.management.resources.GenericResources;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.management.resources.Subscriptions;
import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConfigResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigResourceManager.class);
    private static final String AZ_CONFIG_RESOURCE_TYPE = "Microsoft.AppConfiguration/configurationStores";
    private final Azure.Authenticated authenticated;

    public ConfigResourceManager(AzureTokenCredentials credentials) {
        Assert.notNull((Object)credentials, (String)"Credential token should not be null.");
        this.authenticated = Azure.authenticate((AzureTokenCredentials)credentials);
    }

    @Nullable
    public Tuple<String, String> findStore(String configStoreName) {
        Assert.hasText((String)configStoreName, (String)"Config store name should not be null or empty.");
        LOGGER.debug("Search config store name {} from Azure Configuration Service.", (Object)configStoreName);
        Subscriptions subscriptions = this.authenticated.subscriptions();
        LOGGER.debug("Subscriptions size: [{}].", (Object)subscriptions.list().size());
        for (Subscription subscription : subscriptions.list()) {
            LOGGER.debug("Search from subscription: [{}].", (Object)subscription.subscriptionId());
            Azure subsAzure = this.authenticated.withSubscription(subscription.subscriptionId());
            GenericResources genericResources = subsAzure.genericResources();
            Optional<Tuple> resourceTuple = genericResources.list().stream().filter(resource -> this.isConfigStoreResource(configStoreName, (GenericResource)resource)).map(resource -> Tuple.of((Object)subscription.subscriptionId(), (Object)resource.resourceGroupName())).findFirst();
            if (!resourceTuple.isPresent()) continue;
            LOGGER.debug("Found resource with SubscriptionId=[{}], ResourceGroup=[{}] for config store [{}].", new Object[]{resourceTuple.get().getFirst(), resourceTuple.get().getSecond(), configStoreName});
            return resourceTuple.get();
        }
        LOGGER.debug("Cannot find config store with name [{}].", (Object)configStoreName);
        return null;
    }

    private boolean isConfigStoreResource(String expectedStoreName, GenericResource resource) {
        LOGGER.debug("Check resource name [{}] and resource type [{}] matches with [{}].", new Object[]{resource.name(), resource.type(), expectedStoreName});
        return expectedStoreName.equalsIgnoreCase(resource.name()) && AZ_CONFIG_RESOURCE_TYPE.equals(resource.type());
    }
}

