/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.managed.identity;

import org.springframework.util.Assert;

public class ConfigAccessKeyResource {
    static final String ARM_ENDPONT = "https://management.azure.com";
    private static final String CONFIG_RESOURCE_VERSION = "2019-02-01-preview";
    private static final String RESOURCE_ID_URL = "%s/subscriptions/%s/resourceGroups/%s/providers/Microsoft.AppConfiguration/configurationStores/%s/listKeys?api-version=%s";
    private final String subscriptionId;
    private final String resourceGroupName;
    private final String configStoreName;

    public ConfigAccessKeyResource(String subscriptionId, String resourceGroupName, String configStoreName) {
        Assert.hasText((String)subscriptionId, (String)"Subscription id should not be null or empty.");
        Assert.hasText((String)resourceGroupName, (String)"Resource group name should not be null or empty.");
        Assert.hasText((String)configStoreName, (String)"Config store name should not be null or empty.");
        this.subscriptionId = subscriptionId;
        this.resourceGroupName = resourceGroupName;
        this.configStoreName = configStoreName;
    }

    public String getResourceIdUrl() {
        return String.format(RESOURCE_ID_URL, ARM_ENDPONT, this.subscriptionId, this.resourceGroupName, this.configStoreName, CONFIG_RESOURCE_VERSION);
    }
}

