/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.managed.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.spring.cloud.config.managed.identity.ConfigAccessKey;
import com.microsoft.azure.spring.cloud.config.managed.identity.ConfigAccessKeyResource;
import com.microsoft.azure.spring.cloud.config.managed.identity.ConfigAccessKeys;
import com.microsoft.azure.spring.cloud.config.managed.identity.ConfigResourceManager;
import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureResourceManagerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureResourceManagerConnector.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final CloseableHttpClient HTTP_CLIENT = HttpClients.createDefault();
    private final AzureTokenCredentials tokenCredentials;
    private final String configStoreName;

    public AzureResourceManagerConnector(AzureTokenCredentials credentials, String configStoreName) {
        this.tokenCredentials = credentials;
        this.configStoreName = configStoreName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConnectionString() {
        String accessToken;
        try {
            accessToken = this.tokenCredentials.getToken("https://management.azure.com");
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to retrieve access token for https://management.azure.com", e);
        }
        ConfigAccessKeyResource keyResource = this.getKeyResource();
        String resourceId = keyResource.getResourceIdUrl();
        HttpPost post = new HttpPost(resourceId);
        post.setHeader("Authorization", "Bearer " + accessToken);
        LOGGER.debug("Acquiring connection string from endpoint {}.", (Object)post.getURI());
        try (CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)post);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                switch (statusCode) {
                    case 404: {
                        throw new IllegalStateException(String.format("The configuration store with name %s and id %s could not be found.", this.configStoreName, resourceId));
                    }
                    case 401: 
                    case 403: {
                        throw new IllegalStateException(String.format("No permission to access configuration store %s", this.configStoreName));
                    }
                }
                throw new IllegalStateException(String.format("Failed to retrieve access key for configuration store %s.", this.configStoreName));
            }
            ConfigAccessKeys result = (ConfigAccessKeys)mapper.readValue(response.getEntity().getContent(), ConfigAccessKeys.class);
            String string = AzureResourceManagerConnector.getConnString(this.configStoreName, result);
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to retrieve access key for configuration store %s.", this.configStoreName), e);
        }
    }

    private static String getConnString(String configStoreName, ConfigAccessKeys result) {
        ConfigAccessKey key = (ConfigAccessKey)result.getAccessKeyList().stream().findFirst().orElseThrow(() -> new IllegalStateException(String.format("Access key should exist for configuration store %s", configStoreName)));
        return key.getConnectionString();
    }

    private ConfigAccessKeyResource getKeyResource() {
        Tuple<String, String> resourceInfo = new ConfigResourceManager(this.tokenCredentials).findStore(this.configStoreName);
        if (resourceInfo == null) {
            throw new IllegalStateException(String.format("No configure store with name %s found, access key cannot be retrieved.", this.configStoreName));
        }
        return new ConfigAccessKeyResource((String)resourceInfo.getFirst(), (String)resourceInfo.getSecond(), this.configStoreName);
    }
}

