/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config.domain;

import com.microsoft.azure.spring.cloud.config.domain.QueryField;
import com.microsoft.azure.spring.cloud.config.domain.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class QueryOptions {
    private List<QueryField> fields = new ArrayList<QueryField>();
    private List<String> keyNames = new ArrayList<String>();
    private List<String> labels = new ArrayList<String>();
    private Range range;
    private QueryField sortField;

    public List<QueryField> getFields() {
        return this.fields;
    }

    public String getFieldsString() {
        if (this.fields != null) {
            return this.fields.stream().map(QueryField::toString).collect(Collectors.joining(","));
        }
        return "";
    }

    public String getKeyNames() {
        return this.keyNames != null ? String.join((CharSequence)",", this.keyNames) : "";
    }

    public String getLabels() {
        return this.labels != null ? String.join((CharSequence)",", this.labels) : "";
    }

    public List<String> getLabelList() {
        return this.labels != null ? this.labels : new ArrayList<String>();
    }

    public Range getRange() {
        return this.range;
    }

    public QueryField getSortField() {
        return this.sortField;
    }

    public QueryOptions withFields(List<QueryField> fields) {
        this.fields = fields;
        return this;
    }

    public QueryOptions withFields(QueryField field) {
        this.fields = Arrays.asList(field);
        return this;
    }

    public QueryOptions withKeyNames(String keyName) {
        if (StringUtils.hasText((String)keyName)) {
            this.withKeyNames(Arrays.asList(keyName.split(",")));
        }
        return this;
    }

    public QueryOptions withKeyNames(List<String> keyNames) {
        if (keyNames != null) {
            this.keyNames = keyNames.stream().filter(name -> StringUtils.hasText((String)name)).map(name -> name.trim()).collect(Collectors.toList());
        }
        return this;
    }

    public QueryOptions withLabels(String labels) {
        if (StringUtils.hasText((String)labels)) {
            this.withLabels(Arrays.asList(labels.split(",")));
        }
        return this;
    }

    public QueryOptions withLabels(List<String> labels) {
        if (labels != null) {
            this.labels = labels.stream().filter(label -> StringUtils.hasText((String)label)).map(label -> label.trim()).collect(Collectors.toList());
        }
        return this;
    }

    public QueryOptions withRange(int startItem, int endItem) {
        this.range = new Range(startItem, endItem);
        return this;
    }

    public QueryOptions withRange(Range range) {
        this.range = range;
        return this;
    }

    public QueryOptions withSortField(QueryField field) {
        this.sortField = field;
        return this;
    }
}

