/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.domain.QueryOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RestAPIBuilder {
    public static final String KEY_VALUE_API = "/kv";
    public static final String REVISIONS_API = "/revisions";
    public static final String NULL_LABEL = "%00";
    private static final String KEY_PARAM = "key";
    private static final String LABEL_PARAM = "label";
    private static final String SELECT_PARAM = "$select";
    private String endpoint;
    private String path;
    private Map<String, String> params = new HashMap<String, String>();

    public RestAPIBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public RestAPIBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    public RestAPIBuilder addParam(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public String buildKVApi(@NonNull QueryOptions options) {
        this.withPath(KEY_VALUE_API);
        this.buildParams(options);
        return this.buildRequestUri();
    }

    public String buildRevisionsApi(@NonNull QueryOptions options) {
        this.withPath(REVISIONS_API);
        this.buildParams(options);
        return this.buildRequestUri();
    }

    private void buildParams(QueryOptions options) {
        String keyNames = options.getKeyNames();
        if (StringUtils.hasText((String)keyNames)) {
            this.addParam(KEY_PARAM, keyNames);
        }
        String label = NULL_LABEL;
        if (StringUtils.hasText((String)options.getLabels())) {
            label = options.getLabels();
        }
        if (StringUtils.hasText((String)label)) {
            this.addParam(LABEL_PARAM, label);
        }
        if (StringUtils.hasText((String)options.getFieldsString())) {
            this.addParam(SELECT_PARAM, options.getFieldsString());
        }
    }

    public String buildKVApi() {
        return this.buildRequestUri();
    }

    private String buildRequestUri() {
        Assert.hasText((String)this.endpoint, (String)"Endpoint should not be empty or null");
        Assert.hasText((String)this.path, (String)"Request path should not be empty or null");
        StringBuilder builder = new StringBuilder();
        builder.append(this.endpoint);
        builder.append(this.path);
        if (this.params != null && !this.params.isEmpty()) {
            if (!this.path.contains("?")) {
                builder.append("?");
            }
            String queryParams = String.join((CharSequence)"&", this.params.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).collect(Collectors.toList()));
            builder.append(queryParams);
        }
        return builder.toString();
    }
}

