/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.resource.ConnectionString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ConfigStore {
    private static final List<String> EMPTY_LABEL_ONLY = Arrays.asList("%00");
    private String name;
    @Nullable
    @Pattern(regexp="(/[a-zA-Z0-9.\\-_]+)*")
    private @Pattern(regexp="(/[a-zA-Z0-9.\\-_]+)*") String prefix;
    private String connectionString;
    @Nullable
    private String label;
    @NotEmpty
    private String watchedKey = "*";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getWatchedKey() {
        return this.watchedKey;
    }

    public void setWatchedKey(String watchedKey) {
        this.watchedKey = watchedKey;
    }

    @PostConstruct
    public void validateAndInit() {
        if (StringUtils.hasText((String)this.label)) {
            Assert.isTrue((!this.label.contains("*") ? 1 : 0) != 0, (String)"Label must not contain asterisk(*).");
        }
        if (StringUtils.hasText((String)this.connectionString)) {
            String endpoint = ConnectionString.of(this.connectionString).getEndpoint();
            try {
                URI uri = new URI(endpoint);
                this.name = uri.getHost().split("\\.")[0];
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Endpoint in connection string is not a valid URI.", e);
            }
        }
        Assert.isTrue((boolean)this.watchedKeyValid(this.watchedKey), (String)"Watched key can only be a single asterisk(*) or a specific key without asterisk(*)");
    }

    private boolean watchedKeyValid(String watchedKey) {
        if (!StringUtils.hasText((String)watchedKey)) {
            return false;
        }
        String trimmedKey = watchedKey.trim();
        return trimmedKey.equals("*") || !trimmedKey.contains("*");
    }

    public List<String> getLabels() {
        if (!StringUtils.hasText((String)this.getLabel())) {
            return EMPTY_LABEL_ONLY;
        }
        List labels = Arrays.stream(this.getLabel().split(",")).filter(StringUtils::hasText).map(String::trim).distinct().collect(Collectors.toList());
        Collections.reverse(labels);
        return labels.isEmpty() ? EMPTY_LABEL_ONLY : labels;
    }
}

