/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.cloud.config.ConfigHttpClient;
import com.microsoft.azure.spring.cloud.config.ConfigServiceOperations;
import com.microsoft.azure.spring.cloud.config.RestAPIBuilder;
import com.microsoft.azure.spring.cloud.config.domain.KeyValueItem;
import com.microsoft.azure.spring.cloud.config.domain.KeyValueResponse;
import com.microsoft.azure.spring.cloud.config.domain.QueryField;
import com.microsoft.azure.spring.cloud.config.domain.QueryOptions;
import com.microsoft.azure.spring.cloud.config.domain.Range;
import com.microsoft.azure.spring.cloud.config.resource.ConnectionString;
import com.microsoft.azure.spring.cloud.config.resource.ConnectionStringPool;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConfigServiceTemplate
implements ConfigServiceOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceTemplate.class);
    private static final String LINK_HEADER = "link";
    private static final String NEXT_PAGE_LINK = "<(.*?)>; rel=\"next\".*";
    private static final Pattern PAGE_LINK_PATTERN = Pattern.compile("<(.*?)>; rel=\"next\".*");
    private static final int TOO_MANY_REQ_CODE = 429;
    private static final String RETRY_AFTER_MS_HEADER = "retry-after-ms";
    private static final String RANGE_HEADER = "Range";
    public static final String LOAD_FAILURE_MSG = "Failed to load keys from Azure Config Service.";
    public static final String LOAD_FAILURE_VERBOSE_MSG = "Failed to load keys from Azure Config Service. With status code: %s, response: %s";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final ConfigHttpClient configClient;
    private final ConnectionStringPool connectionStringPool;

    public ConfigServiceTemplate(ConfigHttpClient httpClient, ConnectionStringPool connectionStringPool) {
        this.configClient = httpClient;
        this.connectionStringPool = connectionStringPool;
    }

    @Override
    public List<KeyValueItem> getKeys(@NonNull String storeName, @NonNull QueryOptions options) {
        Assert.hasText((String)storeName, (String)"Config store name should not be null or empty.");
        Assert.notNull((Object)options, (String)"The query options should not be null.");
        ConnectionString connString = this.connectionStringPool.get(storeName);
        String storeEndpoint = connString.getEndpoint();
        String requestUri = new RestAPIBuilder().withEndpoint(storeEndpoint).buildKVApi(options);
        return this.getKeys(requestUri, options, storeName);
    }

    @Override
    public List<KeyValueItem> getRevisions(@NonNull String storeName, @NonNull QueryOptions options) {
        Assert.hasText((String)storeName, (String)"Config store name should not be null or empty.");
        Assert.notNull((Object)options, (String)"Query options should not be null or empty.");
        ConnectionString connString = this.connectionStringPool.get(storeName);
        String storeEndpoint = connString.getEndpoint();
        String requestUri = new RestAPIBuilder().withEndpoint(storeEndpoint).buildRevisionsApi(options);
        return this.getKeys(requestUri, options, storeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyValueItem> getKeys(String requestUri, QueryOptions options, String storeName) {
        ConnectionString connString = this.connectionStringPool.get(storeName);
        String storeEndpoint = connString.getEndpoint();
        ArrayList<KeyValueItem> result = new ArrayList<KeyValueItem>();
        CloseableHttpResponse response = null;
        try {
            while ((response = this.getRawResponse(requestUri, connString, options)) != null) {
                if (this.isThrottled(response)) {
                    this.throttleOnResponse(response);
                    continue;
                }
                try {
                    KeyValueResponse kvResponse = (KeyValueResponse)mapper.readValue(response.getEntity().getContent(), KeyValueResponse.class);
                    List<KeyValueItem> items = kvResponse.getItems();
                    if (options.getSortField() != null && options.getSortField().equals((Object)QueryField.LABEL)) {
                        this.sortByLabel(items, options.getLabelList());
                    }
                    result.addAll(items);
                }
                catch (IOException e) {
                    throw new IllegalStateException(LOAD_FAILURE_MSG, e);
                }
                if (this.itemsReachedRange(result, options.getRange())) {
                    break;
                }
                String nextLink = ConfigServiceTemplate.getNextLink(response);
                if (!StringUtils.hasText((String)nextLink)) {
                    break;
                }
                requestUri = new RestAPIBuilder().withEndpoint(storeEndpoint).withPath(nextLink).buildKVApi();
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Response was not closed successfully.", (Throwable)e);
                }
            }
        }
        return result;
    }

    private boolean itemsReachedRange(List<KeyValueItem> items, Range range) {
        if (range == null) {
            return false;
        }
        int maxSize = range.getEndItem() - range.getStartItem() + 1;
        int itemsSize = items == null ? 0 : items.size();
        return itemsSize >= maxSize;
    }

    private boolean isThrottled(@NonNull CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode() == 429;
    }

    private void throttleOnResponse(@NonNull CloseableHttpResponse response) {
        Header retryHeader = response.getFirstHeader(RETRY_AFTER_MS_HEADER);
        if (retryHeader == null || Long.valueOf(retryHeader.getValue()) <= 0L) {
            throw new IllegalStateException("retry-after-ms header is missing or with illegal value for status code 429");
        }
        long sleepMillSecs = Long.valueOf(retryHeader.getValue());
        try {
            LOGGER.debug("Will sleep {} milli-seconds as received too many requests response.", (Object)sleepMillSecs);
            Thread.sleep(sleepMillSecs);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to sleep for too many requests response.", e);
        }
    }

    private void sortByLabel(List<KeyValueItem> items, List<String> labels) {
        if (items == null || items.size() <= 1 || labels == null || labels.size() <= 1) {
            return;
        }
        HashMap labelIndex = new HashMap();
        items.sort((o1, o2) -> {
            Integer o1Index = labelIndex.computeIfAbsent(this.getLabelValue((KeyValueItem)o1), t -> labels.indexOf(t));
            Integer o2Index = labelIndex.computeIfAbsent(this.getLabelValue((KeyValueItem)o2), t -> labels.indexOf(t));
            return o1Index - o2Index;
        });
    }

    private String getLabelValue(KeyValueItem item) {
        if (StringUtils.hasText((String)item.getLabel())) {
            return item.getLabel();
        }
        return "%00";
    }

    private CloseableHttpResponse getRawResponse(String requestUri, @NonNull ConnectionString connString, QueryOptions options) {
        HttpGet httpGet = new HttpGet(requestUri);
        this.setRequestHeader(httpGet, options);
        Date date = new Date();
        LOGGER.debug("Loading key-value items from Azure Config service at [{}].", (Object)requestUri);
        try {
            CloseableHttpResponse response = this.configClient.execute((HttpUriRequest)httpGet, date, connString.getId(), connString.getSecret());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200 || statusCode == 206 || statusCode == 429) {
                return response;
            }
            if (statusCode == 416) {
                LOGGER.warn("The range {} is not satisfiable for request uri {}.", (Object)options.getRange(), (Object)requestUri);
                return null;
            }
            if (statusCode == 404) {
                LOGGER.warn("No configuration data found in Azure Config Service for request uri {}.", (Object)requestUri);
                return null;
            }
            throw new IllegalStateException(String.format(LOAD_FAILURE_VERBOSE_MSG, statusCode, response));
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error(LOAD_FAILURE_MSG, (Throwable)e);
            throw new IllegalStateException(LOAD_FAILURE_MSG, e);
        }
    }

    private static String getNextLink(@NonNull CloseableHttpResponse response) {
        Header linkHeader = response.getFirstHeader(LINK_HEADER);
        if (linkHeader == null || !StringUtils.hasText((String)linkHeader.getValue())) {
            return "";
        }
        Matcher linkMatcher = PAGE_LINK_PATTERN.matcher(linkHeader.getValue());
        return linkMatcher.matches() ? linkMatcher.group(1) : "";
    }

    private void setRequestHeader(HttpGet httpGet, QueryOptions options) {
        if (options.getRange() != null) {
            httpGet.setHeader(RANGE_HEADER, options.getRange().toString());
        }
    }
}

