/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.HostType;
import com.microsoft.azure.spring.cloud.config.RequestTracingConstants;
import com.microsoft.azure.spring.cloud.config.RequestType;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class ConfigHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHttpClient.class);
    private static final String DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private static final SimpleDateFormat GMT_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    private static final String PACKAGE_NAME = ConfigHttpClient.class.getPackage().getImplementationTitle();
    public static final String USER_AGENT = String.format("%s/%s", StringUtils.remove((String)PACKAGE_NAME, (String)" "), ConfigHttpClient.class.getPackage().getImplementationVersion());
    private final CloseableHttpClient httpClient;

    public ConfigHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CloseableHttpResponse execute(@NonNull HttpUriRequest request, Date date, String credential, String secret) throws IOException, URISyntaxException {
        Assert.notNull((Object)request, (String)"Request should not be null.");
        Map<String, String> authHeaders = ConfigHttpClient.buildRequestHeaders(request, date, credential, secret);
        authHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequest)request).setHeader(arg_0, arg_1));
        return this.httpClient.execute(request);
    }

    private static Map<String, String> buildRequestHeaders(HttpUriRequest request, Date date, String credential, String secret) throws URISyntaxException, IOException {
        String requestTime = GMT_DATE_FORMAT.format(date);
        String contentHash = ConfigHttpClient.buildContentHash(request);
        String signedHeaders = "x-ms-date;host;x-ms-content-sha256";
        String signature = ConfigHttpClient.buildSignature(request, requestTime, contentHash, secret);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-date", requestTime);
        headers.put("x-ms-client-request-id", UUID.randomUUID().toString());
        headers.put("x-ms-content-sha256", contentHash);
        headers.put("correlation-context", ConfigHttpClient.getTracingInfo(request));
        String authorization = String.format("HMAC-SHA256 Credential=%s, SignedHeaders=%s, Signature=%s", credential, signedHeaders, signature);
        headers.put("Authorization", authorization);
        headers.put("User-Agent", USER_AGENT);
        return headers;
    }

    private static String buildContentHash(HttpUriRequest request) throws IOException {
        String content = "";
        if (request instanceof HttpEntityEnclosingRequest) {
            content = ConfigHttpClient.copyInputStream(((HttpEntityEnclosingRequest)request).getEntity().getContent());
        }
        byte[] digest = new DigestUtils("SHA-256").digest(content);
        return Base64.getEncoder().encodeToString(digest);
    }

    private static String buildSignature(HttpUriRequest request, String requestTime, String contentHash, String secret) throws URISyntaxException {
        String methodName = request.getRequestLine().getMethod().toUpperCase();
        String requestPath = ConfigHttpClient.getRequestPath((HttpRequest)request);
        String host = ConfigHttpClient.getHost((HttpRequest)request);
        String toSign = String.format("%s\n%s\n%s;%s;%s", methodName, requestPath, requestTime, host, contentHash);
        byte[] decodedKey = Base64.getDecoder().decode(secret);
        return ConfigHttpClient.encodeHmac(HmacAlgorithms.HMAC_SHA_256, decodedKey, toSign);
    }

    private static String getRequestPath(HttpRequest request) throws URISyntaxException {
        URIBuilder uri = new URIBuilder(request.getRequestLine().getUri());
        String scheme = uri.getScheme() + "://";
        return uri.toString().substring(scheme.length()).substring(uri.getHost().length());
    }

    private static String getHost(HttpRequest request) throws URISyntaxException {
        return new URIBuilder(request.getRequestLine().getUri()).getHost();
    }

    private static String encodeHmac(HmacAlgorithms algorithm, byte[] key, String data) {
        return Base64.getEncoder().encodeToString(new HmacUtils(algorithm, key).hmac(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String copyInputStream(InputStream inputStream) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
            String string = writer.toString();
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.trace("Failed to close the input stream.", (Throwable)e);
            }
        }
    }

    private static String getTracingInfo(HttpUriRequest request) {
        String track = System.getenv(RequestTracingConstants.AZURE_APP_CONFIGURATION_TRACING_DISABLED.toString());
        if (track != null && track.equalsIgnoreCase("false")) {
            return "";
        }
        String requestTypeValue = request.getURI().getPath().startsWith("/kv") ? RequestType.STARTUP.toString() : RequestType.WATCH.toString();
        String requestType = RequestTracingConstants.REQUEST_TYPE.toString() + "=" + requestTypeValue;
        String host = (Object)((Object)RequestTracingConstants.HOST) + "=" + ConfigHttpClient.getHostType();
        return requestType + "," + host;
    }

    private static String getHostType() {
        String azureFunctionVersion = System.getenv(RequestTracingConstants.FUNCTIONS_EXTENSION_VERSION.toString());
        String azureWebsiteVersion = System.getenv(RequestTracingConstants.WEBSITE_NODE_DEFAULT_VERSION.toString());
        HostType hostType = azureFunctionVersion != null ? HostType.AZURE_FUNCTION : (azureWebsiteVersion != null ? HostType.AZURE_WEB_APP : HostType.NONE);
        return hostType.toString();
    }

    static {
        GMT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

