/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.google.common.collect.Lists;
import com.microsoft.azure.spring.cloud.config.AzureCloudConfigProperties;
import com.microsoft.azure.spring.cloud.config.AzureConfigPropertySource;
import com.microsoft.azure.spring.cloud.config.ConfigServiceOperations;
import com.microsoft.azure.spring.cloud.config.ConfigStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AzureConfigPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureConfigPropertySourceLocator.class);
    private static final String SPRING_APP_NAME_PROP = "spring.application.name";
    private static final String PROPERTY_SOURCE_NAME = "azure-config-store";
    private static final String PATH_SPLITTER = "/";
    private final ConfigServiceOperations operations;
    private final AzureCloudConfigProperties properties;
    private final String profileSeparator;
    private final List<ConfigStore> configStores;
    private final Map<String, List<String>> storeContextsMap = new ConcurrentHashMap<String, List<String>>();

    public AzureConfigPropertySourceLocator(ConfigServiceOperations operations, AzureCloudConfigProperties properties) {
        this.operations = operations;
        this.properties = properties;
        this.profileSeparator = properties.getProfileSeparator();
        this.configStores = properties.getStores();
    }

    public PropertySource<?> locate(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            return null;
        }
        ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
        String applicationName = this.properties.getName();
        if (!StringUtils.hasText((String)applicationName)) {
            applicationName = env.getProperty(SPRING_APP_NAME_PROP);
        }
        List<String> profiles = Arrays.asList(env.getActiveProfiles());
        CompositePropertySource composite = new CompositePropertySource(PROPERTY_SOURCE_NAME);
        Collections.reverse(this.configStores);
        for (ConfigStore configStore : this.configStores) {
            this.addPropertySource(composite, configStore, applicationName, profiles, this.storeContextsMap);
        }
        return composite;
    }

    public Map<String, List<String>> getStoreContextsMap() {
        return this.storeContextsMap;
    }

    private void addPropertySource(CompositePropertySource composite, ConfigStore store, String applicationName, List<String> profiles, Map<String, List<String>> storeContextsMap) {
        ArrayList<String> contexts = new ArrayList<String>();
        contexts.addAll(this.generateContexts(this.properties.getDefaultContext(), profiles, store));
        contexts.addAll(this.generateContexts(applicationName, profiles, store));
        Collections.reverse(contexts);
        for (String sourceContext : contexts) {
            try {
                List<AzureConfigPropertySource> sourceList = this.create(sourceContext, store, storeContextsMap);
                sourceList.forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
                LOGGER.debug("PropertySource context [{}] is added.", (Object)sourceContext);
            }
            catch (Exception e) {
                if (this.properties.isFailFast()) {
                    LOGGER.error("Fail fast is set and there was an error reading configuration from Azure Config Service for " + sourceContext, (Throwable)e);
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                    continue;
                }
                LOGGER.warn("Unable to load configuration from Azure Config Service for " + sourceContext, (Throwable)e);
            }
        }
    }

    private List<String> generateContexts(String applicationName, List<String> profiles, ConfigStore configStore) {
        ArrayList<String> result = new ArrayList<String>();
        if (!StringUtils.hasText((String)applicationName)) {
            return result;
        }
        String prefix = configStore.getPrefix();
        String prefixedContext = this.propWithAppName(prefix, applicationName);
        result.add(prefixedContext + PATH_SPLITTER);
        profiles.forEach(profile -> result.add(this.propWithProfile(prefixedContext, (String)profile)));
        return result;
    }

    private String propWithAppName(String prefix, String applicationName) {
        if (StringUtils.hasText((String)prefix)) {
            return prefix.startsWith(PATH_SPLITTER) ? prefix + PATH_SPLITTER + applicationName : PATH_SPLITTER + prefix + PATH_SPLITTER + applicationName;
        }
        return PATH_SPLITTER + applicationName;
    }

    private String propWithProfile(String context, String profile) {
        return context + this.profileSeparator + profile + PATH_SPLITTER;
    }

    private List<AzureConfigPropertySource> create(String context, ConfigStore store, Map<String, List<String>> storeContextsMap) throws IOException {
        ArrayList<AzureConfigPropertySource> sourceList = new ArrayList<AzureConfigPropertySource>();
        for (String label : store.getLabels()) {
            AzureConfigPropertySource propertySource = new AzureConfigPropertySource(context, this.operations, store.getName(), label, this.properties);
            propertySource.initProperties();
            sourceList.add(propertySource);
            this.putStoreContext(store.getName(), context, storeContextsMap);
        }
        return sourceList;
    }

    private void putStoreContext(String storeName, String context, @NonNull Map<String, List<String>> storeContextsMap) {
        if (!StringUtils.hasText((String)context) || !StringUtils.hasText((String)storeName)) {
            return;
        }
        ArrayList contexts = storeContextsMap.get(storeName);
        if (contexts == null) {
            contexts = Lists.newArrayList((Object[])new String[]{context});
        } else {
            contexts.add((String)context);
        }
        storeContextsMap.put(storeName, contexts);
    }
}

