/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.cloud.config.AzureCloudConfigProperties;
import com.microsoft.azure.spring.cloud.config.ConfigServiceOperations;
import com.microsoft.azure.spring.cloud.config.domain.KeyValueItem;
import com.microsoft.azure.spring.cloud.config.domain.QueryOptions;
import com.microsoft.azure.spring.cloud.config.feature.management.entity.Feature;
import com.microsoft.azure.spring.cloud.config.feature.management.entity.FeatureManagementItem;
import com.microsoft.azure.spring.cloud.config.feature.management.entity.FeatureSet;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.EnumerablePropertySource;

public class AzureConfigPropertySource
extends EnumerablePropertySource<ConfigServiceOperations> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureConfigPropertySource.class);
    private final String context;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final String storeName;
    private final String label;
    private AzureCloudConfigProperties azureProperties;
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String FEATURE_MANAGEMENT_KEY = "feature-management.featureManagement";
    private static final String FEATURE_FLAG_CONTENT_TYPE = "application/vnd.microsoft.appconfig.ff+json;charset=utf-8";
    private static final String FEATURE_FLAG_PREFIX = ".appconfig.featureflag/";

    public AzureConfigPropertySource(String context, ConfigServiceOperations operations, String storeName, String label, AzureCloudConfigProperties azureProperties) {
        super(context + storeName + "/" + label, (Object)operations);
        this.context = context;
        this.storeName = storeName;
        this.label = label;
        this.azureProperties = azureProperties;
    }

    public String[] getPropertyNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void initProperties() throws IOException {
        QueryOptions queryOptions = new QueryOptions().withKeyNames(this.context + "*").withLabels(this.label);
        List<KeyValueItem> items = ((ConfigServiceOperations)this.source).getKeys(this.storeName, queryOptions);
        for (KeyValueItem item : items) {
            String key = item.getKey().trim().substring(this.context.length()).replace('/', '.');
            this.properties.put(key, item.getValue());
        }
        queryOptions = new QueryOptions().withKeyNames("*appconfig*").withLabels(this.label);
        items = ((ConfigServiceOperations)this.source).getKeys(this.storeName, queryOptions);
        this.createFeatureSet(items);
    }

    private void createFeatureSet(List<KeyValueItem> items) throws IOException {
        FeatureSet featureSet = new FeatureSet();
        for (KeyValueItem item : items) {
            Object feature = this.createFeature(item);
            if (feature == null) continue;
            String key = item.getKey().trim().substring(FEATURE_FLAG_PREFIX.length());
            featureSet.addFeature(key, feature);
        }
        this.properties.put(FEATURE_MANAGEMENT_KEY, mapper.convertValue((Object)featureSet, LinkedHashMap.class));
    }

    private Object createFeature(KeyValueItem item) throws IOException {
        Feature feature = null;
        if (item.getContentType().equals(FEATURE_FLAG_CONTENT_TYPE)) {
            try {
                FeatureManagementItem featureItem = (FeatureManagementItem)mapper.readValue(item.getValue(), FeatureManagementItem.class);
                feature = new Feature(featureItem);
                if (feature.getEnabledFor().size() == 0 && feature.getEnabled()) {
                    return true;
                }
                return feature;
            }
            catch (IOException e) {
                LOGGER.error("Unabled to parse Feature Management values from Azure.", (Throwable)e);
                if (this.azureProperties.isFailFast()) {
                    throw e;
                }
            }
        } else {
            LOGGER.error(String.format("Found Feature Flag %s with invalid Content Type of %s", item.getKey(), item.getContentType()));
            if (this.azureProperties.isFailFast()) {
                throw new IOException();
            }
        }
        return feature;
    }
}

