/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.AzureCloudConfigProperties;
import com.microsoft.azure.spring.cloud.config.ConfigServiceOperations;
import com.microsoft.azure.spring.cloud.config.ConfigStore;
import com.microsoft.azure.spring.cloud.config.domain.KeyValueItem;
import com.microsoft.azure.spring.cloud.config.domain.QueryField;
import com.microsoft.azure.spring.cloud.config.domain.QueryOptions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.StringUtils;

public class AzureCloudConfigWatch
implements ApplicationEventPublisherAware,
SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureCloudConfigWatch.class);
    private final ConfigServiceOperations configOperations;
    private final Map<String, String> storeEtagMap = new ConcurrentHashMap<String, String>();
    private final TaskScheduler taskScheduler;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> watchFuture;
    private final AzureCloudConfigProperties properties;
    private final Map<String, Boolean> firstTimeMap = new ConcurrentHashMap<String, Boolean>();
    private final List<ConfigStore> configStores;
    private final Map<String, List<String>> storeContextsMap;
    private static final String CONFIGURATION_SUFFIX = "_configuration";
    private static final String FEATURE_SUFFIX = "_feature";
    private static final String FEATURE_STORE_WATCH_KEY = "*appconfig*";

    public AzureCloudConfigWatch(ConfigServiceOperations operations, AzureCloudConfigProperties properties, TaskScheduler scheduler, Map<String, List<String>> storeContextsMap) {
        this.configOperations = operations;
        this.properties = properties;
        this.taskScheduler = scheduler;
        this.configStores = properties.getStores();
        this.storeContextsMap = storeContextsMap;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(this::watchConfigKeyValues, this.properties.getWatch().getDelay());
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false) && this.watchFuture != null) {
            this.watchFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public void watchConfigKeyValues() {
        if (!this.running.get()) {
            return;
        }
        for (ConfigStore configStore : this.configStores) {
            if (this.needRefreshConfiguration(configStore) || this.needRefreshFeatureFlag(configStore)) break;
        }
    }

    private boolean needRefreshConfiguration(ConfigStore store) {
        String watchedKeyNames = this.watchedKeyNames(store, this.storeContextsMap);
        return this.needRefresh(store, CONFIGURATION_SUFFIX, watchedKeyNames);
    }

    private boolean needRefreshFeatureFlag(ConfigStore store) {
        return this.needRefresh(store, FEATURE_SUFFIX, FEATURE_STORE_WATCH_KEY);
    }

    private boolean needRefresh(ConfigStore store, String storeSuffix, String watchedKeyNames) {
        QueryOptions options = new QueryOptions().withKeyNames(watchedKeyNames).withLabels(store.getLabels()).withFields(QueryField.ETAG).withRange(0, 0);
        List<KeyValueItem> keyValueItems = this.configOperations.getRevisions(store.getName(), options);
        if (keyValueItems.isEmpty()) {
            return false;
        }
        String etag = keyValueItems.get(0).getEtag();
        if (this.firstTimeMap.get(store.getName() + storeSuffix) == null) {
            this.storeEtagMap.put(store.getName() + storeSuffix, etag);
            this.firstTimeMap.put(store.getName() + storeSuffix, false);
            return false;
        }
        if (!etag.equals(this.storeEtagMap.get(store.getName() + storeSuffix))) {
            LOGGER.trace("Some keys in store [{}] matching [{}] is updated, will send refresh event.", (Object)store.getName(), (Object)watchedKeyNames);
            this.storeEtagMap.put(store.getName() + storeSuffix, etag);
            RefreshEventData eventData = new RefreshEventData(watchedKeyNames);
            this.publisher.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, (Object)eventData, eventData.getMessage()));
            return true;
        }
        return false;
    }

    private String watchedKeyNames(ConfigStore store, Map<String, List<String>> storeContextsMap) {
        String prefix = store.getPrefix();
        String watchedKey = store.getWatchedKey().trim();
        List<String> contexts = storeContextsMap.get(store.getName());
        String watchedKeys = contexts.stream().map(ctx -> this.genKey(prefix, (String)ctx, watchedKey)).collect(Collectors.joining(","));
        if (watchedKeys.contains(",") && watchedKeys.contains("*")) {
            watchedKeys = "*";
        }
        return watchedKeys;
    }

    private String genKey(@Nullable String prefix, @NonNull String context, @Nullable String watchedKey) {
        String trimmedWatchedKey = StringUtils.hasText((String)watchedKey) ? watchedKey.trim() : "*";
        String trimmedPrefix = StringUtils.hasText((String)prefix) ? prefix.trim() : "";
        return String.format("%s%s%s", trimmedPrefix, context, trimmedWatchedKey);
    }

    class RefreshEventData {
        private static final String MSG_TEMPLATE = "Some keys matching %s has been updated since last check.";
        private final String message;

        public RefreshEventData(String prefix) {
            this.message = String.format(MSG_TEMPLATE, prefix);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

