/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.ConfigStore;
import com.microsoft.azure.spring.cloud.context.core.config.AzureManagedIdentityProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="spring.cloud.azure.appconfiguration")
public class AzureCloudConfigProperties {
    public static final String CONFIG_PREFIX = "spring.cloud.azure.appconfiguration";
    public static final String LABEL_SEPARATOR = ",";
    private boolean enabled = true;
    private List<ConfigStore> stores = new ArrayList<ConfigStore>();
    @NotEmpty
    private String defaultContext = "application";
    @Nullable
    private String name;
    @NestedConfigurationProperty
    private AzureManagedIdentityProperties managedIdentity;
    @NotEmpty
    @Pattern(regexp="^[a-zA-Z0-9_@]+$")
    private @NotEmpty @Pattern(regexp="^[a-zA-Z0-9_@]+$") String profileSeparator = "_";
    private boolean failFast = true;
    private Watch watch = new Watch();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<ConfigStore> getStores() {
        return this.stores;
    }

    public void setStores(List<ConfigStore> stores) {
        this.stores = stores;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public AzureManagedIdentityProperties getManagedIdentity() {
        return this.managedIdentity;
    }

    public void setManagedIdentity(AzureManagedIdentityProperties managedIdentity) {
        this.managedIdentity = managedIdentity;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public void setWatch(Watch watch) {
        this.watch = watch;
    }

    @PostConstruct
    public void validateAndInit() {
        Assert.notEmpty(this.stores, (String)"At least one config store has to be configured.");
        this.stores.forEach(store -> {
            Assert.isTrue((StringUtils.hasText((String)store.getName()) || StringUtils.hasText((String)store.getConnectionString()) ? 1 : 0) != 0, (String)"Either configuration store name or connection string should be configured.");
            store.validateAndInit();
        });
        int uniqueStoreSize = this.stores.stream().map(s -> s.getName()).distinct().collect(Collectors.toList()).size();
        Assert.isTrue((this.stores.size() == uniqueStoreSize ? 1 : 0) != 0, (String)"Duplicate store name exists.");
    }

    class Watch {
        private boolean enabled = false;
        private Duration delay = Duration.ofSeconds(30L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public void setDelay(Duration delay) {
            this.delay = delay;
        }
    }
}

