/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.microsoft.azure.spring.cloud.config.AzureCloudConfigProperties;
import com.microsoft.azure.spring.cloud.config.AzureCloudConfigWatch;
import com.microsoft.azure.spring.cloud.config.AzureConfigPropertySourceLocator;
import com.microsoft.azure.spring.cloud.config.ConfigServiceOperations;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@ConditionalOnProperty(prefix="spring.cloud.azure.appconfiguration", name={"enabled"}, matchIfMissing=true)
public class AzureCloudConfigAutoConfiguration {
    public static final String WATCH_TASK_SCHEDULER_NAME = "azureConfigWatchTaskScheduler";

    @Configuration
    @ConditionalOnClass(value={RefreshEndpoint.class})
    @ConditionalOnProperty(prefix="spring.cloud.azure.appconfiguration", name={"watch.enabled"})
    static class CloudWatchAutoConfiguration {
        CloudWatchAutoConfiguration() {
        }

        @Bean
        public AzureCloudConfigWatch getConfigWatch(ConfigServiceOperations operations, AzureCloudConfigProperties properties, @Qualifier(value="azureConfigWatchTaskScheduler") TaskScheduler scheduler, AzureConfigPropertySourceLocator sourceLocator) {
            return new AzureCloudConfigWatch(operations, properties, scheduler, sourceLocator.getStoreContextsMap());
        }

        @Bean(name={"azureConfigWatchTaskScheduler"})
        @ConditionalOnMissingBean
        public TaskScheduler getTaskScheduler() {
            return new ThreadPoolTaskScheduler();
        }
    }
}

