/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttQos;

public class MqttMessage {
    private String topic;
    private byte[] payload;
    private MqttQos qos = MqttQos.DELIVER_UNKNOWN;

    public MqttMessage(String topic) {
        this.topic = topic;
    }

    public MqttMessage(String topic, org.eclipse.paho.client.mqttv3.MqttMessage mqttMessage) {
        if (mqttMessage == null) {
            throw new IllegalArgumentException();
        }
        this.topic = topic;
        this.payload = mqttMessage.getPayload();
        int qosValue = mqttMessage.getQos();
        this.qos = qosValue == 0 ? MqttQos.DELIVER_AT_MOST_ONCE : (qosValue == 2 ? MqttQos.DELIVER_EXACTLY_ONCE : (qosValue == 3 ? MqttQos.DELIVER_AT_LEAST_ONCE : MqttQos.DELIVER_FAILURE));
    }

    public MqttMessage(String topic, byte[] payload) {
        this.topic = topic;
        this.payload = payload;
    }

    public static int retrieveQosValue(MqttQos qos) {
        int result = qos == MqttQos.DELIVER_AT_MOST_ONCE ? 0 : (qos == MqttQos.DELIVER_AT_LEAST_ONCE ? 1 : (qos == MqttQos.DELIVER_EXACTLY_ONCE ? 2 : 128));
        return result;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setQos(MqttQos qos) {
        this.qos = qos;
    }

    public MqttQos getQos() {
        return this.qos;
    }

    public org.eclipse.paho.client.mqttv3.MqttMessage getMqttMessage() {
        org.eclipse.paho.client.mqttv3.MqttMessage mqttMessage = new org.eclipse.paho.client.mqttv3.MqttMessage();
        if (this.payload != null) {
            mqttMessage.setPayload(this.payload);
        }
        if (this.qos != MqttQos.DELIVER_UNKNOWN) {
            mqttMessage.setQos(MqttMessage.retrieveQosValue(this.qos));
        }
        return mqttMessage;
    }
}

