/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttListener;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttMessage;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttQos;
import java.io.IOException;
import java.util.UUID;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttConnection
implements MqttCallback {
    private static final String WS_SSL_URL_FORMAT = "wss://%s:443";
    private static final String SSL_URL_FORMAT = "ssl://%s:8883";
    private MqttAsyncClient mqttAsyncClient;
    private MqttConnectOptions connectionOptions;
    private static final int KEEP_ALIVE_INTERVAL = 230;
    private static final int MQTT_VERSION = 4;
    private static final boolean SET_CLEAN_SESSION = false;
    private static final int SUBSCRIBE_REQUEST_MAX_WAIT_TIME_MILLISECONDS = 60000;
    private final MqttListener mqttListener;
    private final String connectionId;
    private final String hostName;

    public MqttConnection(String hostname, String clientId, String userName, String password, SSLContext sslContext, MqttListener listener, boolean useWebSockets) throws IOException {
        if (hostname == null || clientId == null || userName == null || sslContext == null) {
            throw new IllegalArgumentException();
        }
        if (hostname.isEmpty() || clientId.isEmpty() || userName.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null.");
        }
        try {
            String serverUri = useWebSockets ? String.format(WS_SSL_URL_FORMAT, hostname) : String.format(SSL_URL_FORMAT, hostname);
            this.hostName = hostname;
            this.mqttListener = listener;
            this.mqttAsyncClient = new MqttAsyncClient(serverUri, clientId, (MqttClientPersistence)new MemoryPersistence());
            this.connectionOptions = new MqttConnectOptions();
            this.mqttAsyncClient.setCallback((MqttCallback)this);
            this.updateConnectionOptions(userName, password, sslContext);
            this.connectionId = UUID.randomUUID().toString();
        }
        catch (MqttException e) {
            this.mqttAsyncClient = null;
            this.connectionOptions = null;
            throw new IOException("Error initializing MQTT connection:" + e.getMessage());
        }
    }

    public boolean isMqttConnected() {
        boolean result = this.mqttAsyncClient == null ? false : this.mqttAsyncClient.isConnected();
        return result;
    }

    private void updateConnectionOptions(String userName, String userPassword, SSLContext sslContext) {
        this.connectionOptions.setKeepAliveInterval(230);
        this.connectionOptions.setCleanSession(false);
        this.connectionOptions.setMqttVersion(4);
        this.connectionOptions.setUserName(userName);
        this.connectionOptions.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
        if (userPassword != null && !userPassword.isEmpty()) {
            this.connectionOptions.setPassword(userPassword.toCharArray());
        }
    }

    public synchronized void connect() throws IOException {
        try {
            if (!this.mqttAsyncClient.isConnected()) {
                IMqttToken connectToken = this.mqttAsyncClient.connect(this.connectionOptions);
                connectToken.waitForCompletion();
            }
        }
        catch (MqttException e) {
            throw new IOException("Unable to connect to mqtt service", e);
        }
    }

    public synchronized void disconnect() throws IOException {
        try {
            if (this.mqttAsyncClient.isConnected()) {
                IMqttToken disconnectToken = this.mqttAsyncClient.disconnect();
                disconnectToken.waitForCompletion();
            }
        }
        catch (MqttException e) {
            throw new IOException("Unable to connect to mqtt service", e);
        }
    }

    public synchronized void publishMessage(String topic, MqttQos qos, byte[] message) throws IOException {
        MqttMessage mqttMessage = message == null || message.length == 0 ? new MqttMessage(topic) : new MqttMessage(topic, message);
        mqttMessage.setQos(qos);
        this.publishMessage(mqttMessage);
    }

    public synchronized void publishMessage(MqttMessage message) throws IOException {
        if (this.mqttAsyncClient == null || !this.mqttAsyncClient.isConnected()) {
            throw new IOException("Mqtt is not connected");
        }
        if (message == null) {
            throw new IOException("MqttMessage is null");
        }
        try {
            IMqttDeliveryToken publishToken = this.mqttAsyncClient.publish(message.getTopic(), message.getMqttMessage());
            publishToken.waitForCompletion();
        }
        catch (MqttException e) {
            throw new IOException("Unable to publish message on topic : " + message.getTopic(), e);
        }
    }

    public synchronized void subscribe(String topic, MqttQos qos) throws IOException {
        if (this.mqttAsyncClient == null || !this.mqttAsyncClient.isConnected()) {
            throw new IOException("Mqtt is not connected");
        }
        try {
            IMqttToken subToken = this.mqttAsyncClient.subscribe(topic, MqttMessage.retrieveQosValue(qos));
            subToken.waitForCompletion(60000L);
        }
        catch (MqttException e) {
            throw new IOException("Unable to subscribe on topic : " + topic, e);
        }
    }

    public synchronized void unsubscribe(String topic) throws IOException {
        try {
            IMqttToken subToken = this.mqttAsyncClient.unsubscribe(topic);
            subToken.waitForCompletion();
        }
        catch (MqttException e) {
            throw new IOException("Unable to unsubscribe message on topic : " + topic, e);
        }
    }

    public synchronized void messageArrived(String topic, org.eclipse.paho.client.mqttv3.MqttMessage mqttMessage) {
        this.mqttListener.messageReceived(new MqttMessage(topic, mqttMessage));
    }

    public synchronized void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
    }

    public synchronized void connectionLost(Throwable throwable) {
        this.mqttListener.connectionLost(throwable);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getHostName() {
        return this.hostName;
    }
}

