/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp;

import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.Event;

public class ProtonJExceptionParser {
    private String error;
    private String errorDescription;
    private static final String DEFAULT_ERROR_DESCRIPTION = "NoErrorDescription";

    public ProtonJExceptionParser(Event event) {
        this.getTransportExceptionFromProtonEndpoints(new Endpoint[]{event.getSender(), event.getReceiver(), event.getConnection(), event.getTransport(), event.getSession(), event.getLink()});
    }

    private ErrorCondition getErrorConditionFromEndpoint(Endpoint endpoint) {
        return endpoint.getCondition() != null && endpoint.getCondition().getCondition() != null ? endpoint.getCondition() : endpoint.getRemoteCondition();
    }

    private void getTransportExceptionFromProtonEndpoints(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            ErrorCondition errorCondition;
            if (endpoint == null || (errorCondition = this.getErrorConditionFromEndpoint(endpoint)) == null || errorCondition.getCondition() == null) continue;
            this.error = errorCondition.getCondition().toString();
            this.errorDescription = errorCondition.getDescription() != null ? errorCondition.getDescription() : DEFAULT_ERROR_DESCRIPTION;
        }
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }
}

