/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp;

import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.ProtonJExceptionParser;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorLoggingBaseHandler
extends BaseHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorLoggingBaseHandler.class);
    protected ProtonJExceptionParser protonJExceptionParser;

    public void onLinkRemoteClose(Event event) {
        if (event.getLink().getLocalState().equals((Object)EndpointState.ACTIVE)) {
            this.protonJExceptionParser = new ProtonJExceptionParser(event);
            if (this.protonJExceptionParser.getError() == null) {
                log.error("Amqp link {} was closed remotely", (Object)event.getLink().getName());
            } else if (event.getLink().getName() != null) {
                log.error("Amqp link {} was closed remotely with exception {} with description {}", new Object[]{event.getLink().getName(), this.protonJExceptionParser.getError(), this.protonJExceptionParser.getErrorDescription()});
            } else {
                log.error("Unknown amqp link was closed remotely with exception {} with description {}", (Object)this.protonJExceptionParser.getError(), (Object)this.protonJExceptionParser.getErrorDescription());
            }
        } else {
            log.trace("Amqp link {} closed remotely after being closed locally", (Object)event.getLink().getName());
        }
    }

    public void onSessionRemoteClose(Event event) {
        if (event.getSession().getLocalState().equals((Object)EndpointState.ACTIVE)) {
            this.protonJExceptionParser = new ProtonJExceptionParser(event);
            if (this.protonJExceptionParser.getError() == null) {
                log.error("Amqp session was closed remotely with an unknown exception");
            } else {
                log.error("Amqp session was closed remotely with exception {} with description {}", (Object)this.protonJExceptionParser.getError(), (Object)this.protonJExceptionParser.getErrorDescription());
            }
        } else {
            log.trace("Amqp session closed remotely after being closed locally");
        }
    }

    public void onConnectionRemoteClose(Event event) {
        if (event.getConnection().getLocalState().equals((Object)EndpointState.ACTIVE)) {
            this.protonJExceptionParser = new ProtonJExceptionParser(event);
            if (this.protonJExceptionParser.getError() == null) {
                log.error("Amqp connection was closed remotely with an unknown exception");
            } else {
                log.error("Amqp connection was closed remotely with exception {} with description {}", (Object)this.protonJExceptionParser.getError(), (Object)this.protonJExceptionParser.getErrorDescription());
            }
        } else {
            log.trace("Amqp connection closed remotely after being closed locally");
        }
    }

    public void onTransportError(Event event) {
        this.protonJExceptionParser = new ProtonJExceptionParser(event);
        if (this.protonJExceptionParser.getError() == null) {
            log.error("Amqp transport threw an unknown exception");
        } else {
            log.error("Amqp transport threw exception {} with description {}", (Object)this.protonJExceptionParser.getError(), (Object)this.protonJExceptionParser.getErrorDescription());
        }
    }
}

