/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp;

import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.AmqpMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;

public class AmqpDeviceOperations {
    private final String senderLinkTag;
    private final String receiverLinkTag;
    private final Map<Symbol, Object> amqpProperties = new HashMap<Symbol, Object>();
    private Sender senderLink = null;
    private Receiver receiverLink = null;
    protected String amqpLinkAddress;

    public AmqpDeviceOperations() {
        this.senderLinkTag = "provision_sender_link";
        this.receiverLinkTag = "provision_receiver_link";
    }

    public AmqpMessage receiverMessageFromLink(String linkName) {
        AmqpMessage result;
        if (linkName == null || linkName.isEmpty()) {
            result = null;
        } else if (this.receiverLink == null) {
            result = null;
        } else {
            Delivery delivery = this.receiverLink.current();
            if (linkName.equals(this.receiverLinkTag) && delivery != null && delivery.isReadable() && !delivery.isPartial()) {
                int size = delivery.pending();
                byte[] buffer = new byte[size];
                int read = this.receiverLink.recv(buffer, 0, buffer.length);
                this.receiverLink.advance();
                result = new AmqpMessage();
                result.decode(buffer, 0, read);
            } else {
                result = null;
            }
        }
        return result;
    }

    public void openLinks(Session session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("The session cannot be null.");
        }
        this.receiverLink = session.receiver(this.receiverLinkTag);
        this.receiverLink.setProperties(this.amqpProperties);
        this.receiverLink.open();
        this.senderLink = session.sender(this.senderLinkTag);
        this.senderLink.setProperties(this.amqpProperties);
        this.senderLink.open();
    }

    public synchronized boolean isReceiverLinkTag(String name) {
        return this.receiverLinkTag.equals(name);
    }

    public synchronized void initLink(Link link) throws IllegalArgumentException {
        if (link == null) {
            throw new IllegalArgumentException("The link cannot be null.");
        }
        if (link.getName().equals(this.senderLinkTag)) {
            Target target = new Target();
            target.setAddress(this.amqpLinkAddress);
            link.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
        } else if (link.getName().equals(this.receiverLinkTag)) {
            Source source = new Source();
            source.setAddress(this.amqpLinkAddress);
            link.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        }
    }

    public void sendMessage(byte[] tag, byte[] data, int length, int offset) {
        this.senderLink.delivery(tag);
        this.senderLink.send(data, offset, length);
        this.senderLink.advance();
    }

    public synchronized void closeLinks() {
        if (this.receiverLink != null) {
            this.receiverLink.close();
        }
        if (this.senderLink != null) {
            this.senderLink.close();
        }
    }

    protected void addAmqpLinkProperty(String key, String value) {
        this.amqpProperties.put(Symbol.getSymbol((String)key), value);
    }
}

