/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.task;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ProvisioningDeviceClientContract;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceSecurityException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.ProvisioningErrorParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.RegistrationOperationStatusParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.Authorization;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ContractState;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RequestData;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ResponseData;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLContext;

class StatusTask
implements Callable<RegistrationOperationStatusParser> {
    private static final int MAX_WAIT_FOR_STATUS_RESPONSE = 100;
    private static final String THREAD_NAME = "azure-iot-sdk-StatusTask";
    private final ProvisioningDeviceClientContract provisioningDeviceClientContract;
    private final ProvisioningDeviceClientConfig provisioningDeviceClientConfig;
    private final SecurityProvider securityProvider;
    private final String operationId;
    private final Authorization authorization;

    StatusTask(SecurityProvider securityProvider, ProvisioningDeviceClientContract provisioningDeviceClientContract, ProvisioningDeviceClientConfig provisioningDeviceClientConfig, String operationId, Authorization authorization) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientContract == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("provisioningDeviceClientContract cannot be null"));
        }
        if (provisioningDeviceClientConfig == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Config cannot be null"));
        }
        if (securityProvider == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("security client cannot be null"));
        }
        if (operationId == null || operationId.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("operationId cannot be null or empty"));
        }
        if (authorization == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("authorization cannot be null"));
        }
        this.securityProvider = securityProvider;
        this.provisioningDeviceClientContract = provisioningDeviceClientContract;
        this.provisioningDeviceClientConfig = provisioningDeviceClientConfig;
        this.operationId = operationId;
        this.authorization = authorization;
    }

    private RegistrationOperationStatusParser getRegistrationStatus(String operationId, Authorization authorization) throws ProvisioningDeviceClientException {
        try {
            String registrationId = this.securityProvider.getRegistrationId();
            if (registrationId == null || registrationId.isEmpty()) {
                throw new ProvisioningDeviceSecurityException("registrationId cannot be null or empty");
            }
            SSLContext sslContext = authorization.getSslContext();
            if (sslContext == null) {
                throw new ProvisioningDeviceSecurityException("SSL context cannot be null");
            }
            RequestData requestData = new RequestData(registrationId, operationId, authorization.getSslContext(), authorization.getSasToken(), null);
            ResponseData responseData = new ResponseData();
            this.provisioningDeviceClientContract.getRegistrationStatus(requestData, new ResponseCallbackImpl(), responseData);
            if (responseData.getResponseData() == null || responseData.getContractState() != ContractState.DPS_REGISTRATION_RECEIVED) {
                Thread.sleep(100L);
            }
            if (responseData.getResponseData() != null && responseData.getContractState() == ContractState.DPS_REGISTRATION_RECEIVED) {
                String jsonBody = new String(responseData.getResponseData(), StandardCharsets.UTF_8);
                try {
                    return RegistrationOperationStatusParser.createFromJson(jsonBody);
                }
                catch (IllegalArgumentException e) {
                    ProvisioningErrorParser provisioningErrorParser = ProvisioningErrorParser.createFromJson(jsonBody);
                    throw new ProvisioningDeviceClientException(provisioningErrorParser.getExceptionMessage());
                }
            }
            throw new ProvisioningDeviceClientException("Did not receive DPS Status information");
        }
        catch (SecurityProviderException | InterruptedException e) {
            throw new ProvisioningDeviceClientException(e);
        }
    }

    @Override
    public RegistrationOperationStatusParser call() throws Exception {
        String threadName = this.provisioningDeviceClientContract.getHostName() + "-" + this.provisioningDeviceClientConfig.getUniqueIdentifier() + "-Cxn" + this.provisioningDeviceClientContract.getConnectionId() + "-" + THREAD_NAME;
        Thread.currentThread().setName(threadName);
        return this.getRegistrationStatus(this.operationId, this.authorization);
    }

    private static class ResponseCallbackImpl
    implements ResponseCallback {
        private ResponseCallbackImpl() {
        }

        @Override
        public void run(ResponseData responseData, Object context) throws ProvisioningDeviceClientException {
            if (!(context instanceof ResponseData)) {
                throw new ProvisioningDeviceClientException("Context mismatch for DPS registration");
            }
            ResponseData data = (ResponseData)context;
            data.setResponseData(responseData.getResponseData());
            data.setContractState(responseData.getContractState());
            data.setWaitForStatusInMilliseconds(responseData.getWaitForStatusInMilliseconds());
        }
    }
}

