/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.task;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ProvisioningDeviceClientContract;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.UrlPathBuilder;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientAuthenticationException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceSecurityException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.ProvisioningErrorParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.RegistrationOperationStatusParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.Authorization;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ContractState;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RequestData;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ResponseData;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderSymmetricKey;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderTpm;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderX509;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegisterTask
implements Callable<RegistrationOperationStatusParser> {
    private static final Logger log = LoggerFactory.getLogger(RegisterTask.class);
    private static final int MAX_WAIT_FOR_REGISTRATION_RESPONSE = 90000;
    private static final int SLEEP_INTERVAL_WHEN_WAITING_FOR_RESPONSE = 4000;
    private static final int DEFAULT_EXPIRY_TIME_IN_SECS = 3600;
    private static final String SASTOKEN_FORMAT = "SharedAccessSignature sr=%s&sig=%s&se=%s&skn=";
    private static final String THREAD_NAME = "azure-iot-sdk-RegisterTask";
    private final ResponseCallback responseCallback;
    private final ProvisioningDeviceClientContract provisioningDeviceClientContract;
    private final Authorization authorization;
    private final SecurityProvider securityProvider;
    private final ProvisioningDeviceClientConfig provisioningDeviceClientConfig;

    RegisterTask(ProvisioningDeviceClientConfig provisioningDeviceClientConfig, SecurityProvider securityProvider, ProvisioningDeviceClientContract provisioningDeviceClientContract, Authorization authorization) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientContract == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("provisioningDeviceClientContract cannot be null"));
        }
        if (securityProvider == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("security client cannot be null"));
        }
        if (provisioningDeviceClientConfig == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("provisioningDeviceClientConfig cannot be null"));
        }
        if (authorization == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("authorization cannot be null"));
        }
        this.provisioningDeviceClientConfig = provisioningDeviceClientConfig;
        this.securityProvider = securityProvider;
        this.provisioningDeviceClientContract = provisioningDeviceClientContract;
        this.authorization = authorization;
        this.responseCallback = new ResponseCallbackImpl();
    }

    private RegistrationOperationStatusParser authenticateWithX509(RequestData requestData) throws ProvisioningDeviceClientException {
        try {
            ResponseData dpsRegistrationData = new ResponseData();
            this.provisioningDeviceClientContract.authenticateWithProvisioningService(requestData, this.responseCallback, dpsRegistrationData);
            this.waitForResponse(dpsRegistrationData);
            if (dpsRegistrationData.getResponseData() != null && dpsRegistrationData.getContractState() == ContractState.DPS_REGISTRATION_RECEIVED) {
                String jsonBody = new String(dpsRegistrationData.getResponseData(), StandardCharsets.UTF_8);
                try {
                    return RegistrationOperationStatusParser.createFromJson(jsonBody);
                }
                catch (IllegalArgumentException e) {
                    ProvisioningErrorParser provisioningErrorParser = ProvisioningErrorParser.createFromJson(jsonBody);
                    throw new ProvisioningDeviceClientException(provisioningErrorParser.getExceptionMessage());
                }
            }
            throw new ProvisioningDeviceClientException("Did not receive DPS registration successfully");
        }
        catch (InterruptedException e) {
            throw new ProvisioningDeviceClientException(e);
        }
    }

    private String constructSasToken() throws ProvisioningDeviceClientException, UnsupportedEncodingException, SecurityProviderException {
        String registrationId = this.securityProvider.getRegistrationId();
        String tokenScope = new UrlPathBuilder(this.provisioningDeviceClientConfig.getIdScope()).generateSasTokenUrl(registrationId);
        if (tokenScope == null || tokenScope.isEmpty()) {
            throw new ProvisioningDeviceClientException("Could not construct token scope");
        }
        Long expiryTimeUTC = System.currentTimeMillis() / 1000L + 3600L;
        String value = tokenScope.concat("\n" + expiryTimeUTC);
        byte[] token = null;
        if (this.securityProvider instanceof SecurityProviderTpm) {
            SecurityProviderTpm securityClientTpm = (SecurityProviderTpm)this.securityProvider;
            token = securityClientTpm.signWithIdentity(value.getBytes(StandardCharsets.UTF_8));
        } else if (this.securityProvider instanceof SecurityProviderSymmetricKey) {
            SecurityProviderSymmetricKey securityProviderSymmetricKey = (SecurityProviderSymmetricKey)this.securityProvider;
            token = securityProviderSymmetricKey.HMACSignData(value.getBytes(StandardCharsets.UTF_8.displayName()), Base64.decodeBase64((byte[])securityProviderSymmetricKey.getSymmetricKey()));
        }
        if (token == null || token.length == 0) {
            throw new ProvisioningDeviceSecurityException("Security client could not sign data successfully");
        }
        byte[] base64Signature = Base64.encodeBase64((byte[])token);
        String base64UrlEncodedSignature = URLEncoder.encode(new String(base64Signature, StandardCharsets.UTF_8), StandardCharsets.UTF_8.displayName());
        return String.format(SASTOKEN_FORMAT, tokenScope, base64UrlEncodedSignature, expiryTimeUTC);
    }

    private RegistrationOperationStatusParser authenticateWithSasToken(RequestData requestData) throws IOException, InterruptedException, ProvisioningDeviceClientException, SecurityProviderException {
        String sasToken = this.constructSasToken();
        requestData.setSasToken(sasToken);
        ResponseData responseDataForSasTokenAuth = new ResponseData();
        this.provisioningDeviceClientContract.authenticateWithProvisioningService(requestData, this.responseCallback, responseDataForSasTokenAuth);
        this.waitForResponse(responseDataForSasTokenAuth);
        if (responseDataForSasTokenAuth.getResponseData() != null && responseDataForSasTokenAuth.getContractState() == ContractState.DPS_REGISTRATION_RECEIVED) {
            this.authorization.setSasToken(sasToken);
            String jsonBody = new String(responseDataForSasTokenAuth.getResponseData(), StandardCharsets.UTF_8);
            try {
                return RegistrationOperationStatusParser.createFromJson(jsonBody);
            }
            catch (IllegalArgumentException e) {
                ProvisioningErrorParser provisioningErrorParser = ProvisioningErrorParser.createFromJson(jsonBody);
                throw new ProvisioningDeviceClientException(provisioningErrorParser.getExceptionMessage());
            }
        }
        throw new ProvisioningDeviceClientAuthenticationException("Service did not authorize SasToken");
    }

    private RegistrationOperationStatusParser authenticateWithTPM(RequestData requestData) throws ProvisioningDeviceClientException, SecurityProviderException {
        try {
            if (this.securityProvider instanceof SecurityProviderTpm) {
                SecurityProviderTpm securityClientTpm = (SecurityProviderTpm)this.securityProvider;
                ResponseData nonceResponseData = new ResponseData();
                log.debug("Requesting service nonce for tpm authentication");
                this.provisioningDeviceClientContract.requestNonceForTPM(requestData, this.responseCallback, nonceResponseData);
                this.waitForResponse(nonceResponseData);
                if (nonceResponseData.getContractState() == ContractState.DPS_REGISTRATION_RECEIVED) {
                    if (nonceResponseData.getResponseData() == null) {
                        throw new ProvisioningDeviceClientAuthenticationException("Service did not send authentication key");
                    }
                    log.debug("Received service nonce, activating tpm identity key with it");
                    securityClientTpm.activateIdentityKey(nonceResponseData.getResponseData());
                    log.debug("Authenticating with device provisioning service using the activated tpm identity key");
                    return this.authenticateWithSasToken(requestData);
                }
                throw new ProvisioningDeviceClientException("Did not receive DPS registration nonce successfully");
            }
            throw new ProvisioningDeviceClientException("could not identify security provider");
        }
        catch (IOException | InterruptedException e) {
            throw new ProvisioningDeviceClientException(e);
        }
    }

    private RegistrationOperationStatusParser authenticateWithDPS() throws ProvisioningDeviceClientException, SecurityProviderException {
        if (this.securityProvider.getRegistrationId() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("registration id cannot be null"));
        }
        try {
            SSLContext sslContext = this.securityProvider.getSSLContext();
            if (sslContext == null) {
                throw new ProvisioningDeviceSecurityException("Null SSL Context received from security client");
            }
            this.authorization.setSslContext(sslContext);
            if (this.securityProvider instanceof SecurityProviderX509) {
                RequestData requestData = new RequestData(this.securityProvider.getRegistrationId(), sslContext, true, this.provisioningDeviceClientConfig.getPayload());
                log.info("Authenticating with device provisioning service using x509 certificates");
                return this.authenticateWithX509(requestData);
            }
            if (this.securityProvider instanceof SecurityProviderTpm) {
                SecurityProviderTpm securityProviderTpm = (SecurityProviderTpm)this.securityProvider;
                if (securityProviderTpm.getEndorsementKey() == null || securityProviderTpm.getStorageRootKey() == null) {
                    throw new ProvisioningDeviceSecurityException(new IllegalArgumentException("Ek or SRK cannot be null"));
                }
                RequestData requestData = new RequestData(securityProviderTpm.getEndorsementKey(), securityProviderTpm.getStorageRootKey(), this.securityProvider.getRegistrationId(), sslContext, null, this.provisioningDeviceClientConfig.getPayload());
                log.info("Authenticating with device provisioning service using tpm");
                return this.authenticateWithTPM(requestData);
            }
            if (this.securityProvider instanceof SecurityProviderSymmetricKey) {
                RequestData requestData = new RequestData(this.securityProvider.getRegistrationId(), sslContext, null, this.provisioningDeviceClientConfig.getPayload());
                log.info("Authenticating with device provisioning service using symmetric key");
                return this.authenticateWithSasToken(requestData);
            }
            throw new ProvisioningDeviceSecurityException("Unknown Security client received");
        }
        catch (SecurityProviderException | IOException | InterruptedException e) {
            throw new ProvisioningDeviceSecurityException(e);
        }
    }

    @Override
    public RegistrationOperationStatusParser call() throws Exception {
        String connectionId = this.provisioningDeviceClientConfig.getUniqueIdentifier();
        if (connectionId == null) {
            connectionId = "PendingConnectionId";
        }
        String threadName = this.provisioningDeviceClientContract.getHostName() + "-" + this.provisioningDeviceClientConfig.getUniqueIdentifier() + "-Cxn" + connectionId + "-" + THREAD_NAME;
        Thread.currentThread().setName(threadName);
        return this.authenticateWithDPS();
    }

    private void waitForResponse(ResponseData responseData) throws InterruptedException {
        long millisecondsElapsed = 0L;
        long waitTimeStart = System.currentTimeMillis();
        while (responseData.getContractState() != ContractState.DPS_REGISTRATION_RECEIVED && millisecondsElapsed < 90000L) {
            Thread.sleep(4000L);
            millisecondsElapsed = System.currentTimeMillis() - waitTimeStart;
        }
    }

    private static class ResponseCallbackImpl
    implements ResponseCallback {
        private ResponseCallbackImpl() {
        }

        @Override
        public void run(ResponseData responseData, Object context) throws ProvisioningDeviceClientException {
            if (!(context instanceof ResponseData)) {
                throw new ProvisioningDeviceClientException(new IllegalArgumentException("Context mismatch for DPS registration"));
            }
            ResponseData data = (ResponseData)context;
            data.setResponseData(responseData.getResponseData());
            data.setContractState(responseData.getContractState());
            data.setWaitForStatusInMilliseconds(responseData.getWaitForStatusInMilliseconds());
        }
    }
}

