/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.task;

import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientRegistrationCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientStatus;
import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientSubstatus;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ProvisioningDeviceClientContract;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientAuthenticationException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceConnectionException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceHubException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.DeviceRegistrationResultParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.RegistrationOperationStatusParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.Authorization;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ProvisioningStatus;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RegisterTask;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RegistrationResult;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RequestData;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.StatusTask;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderTpm;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderX509;
import com.microsoft.azure.sdk.iot.provisioning.security.exceptions.SecurityProviderException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningTask
implements Callable<Object> {
    private static final Logger log = LoggerFactory.getLogger(ProvisioningTask.class);
    private static final int MAX_THREADS_TO_RUN = 2;
    private static final int MAX_TIME_TO_WAIT_FOR_REGISTRATION = 1000000;
    private static final int MAX_TIME_TO_WAIT_FOR_STATUS_UPDATE = 10000;
    private static final String THREAD_NAME = "azure-iot-sdk-ProvisioningTask";
    private final SecurityProvider securityProvider;
    private final ProvisioningDeviceClientContract provisioningDeviceClientContract;
    private final ProvisioningDeviceClientConfig provisioningDeviceClientConfig;
    private final ProvisioningDeviceClientRegistrationCallback provisioningDeviceClientRegistrationCallback;
    private final Object dpsRegistrationCallbackContext;
    private final Authorization authorization;
    private ProvisioningDeviceClientStatus dpsStatus = null;
    private final ExecutorService executor;

    public ProvisioningTask(ProvisioningDeviceClientConfig provisioningDeviceClientConfig, ProvisioningDeviceClientContract provisioningDeviceClientContract) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientContract == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("DPS Transport cannot be null"));
        }
        if (provisioningDeviceClientConfig == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Config cannot be null"));
        }
        this.provisioningDeviceClientConfig = provisioningDeviceClientConfig;
        this.securityProvider = provisioningDeviceClientConfig.getSecurityProvider();
        if (this.securityProvider == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Security client cannot be null"));
        }
        this.provisioningDeviceClientContract = provisioningDeviceClientContract;
        this.provisioningDeviceClientRegistrationCallback = provisioningDeviceClientConfig.getRegistrationCallback();
        this.dpsRegistrationCallbackContext = provisioningDeviceClientConfig.getRegistrationCallbackContext();
        if (this.provisioningDeviceClientRegistrationCallback == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Registration callback cannot be null"));
        }
        this.authorization = new Authorization();
        this.executor = Executors.newFixedThreadPool(2);
    }

    private void invokeRegistrationCallback(RegistrationResult registrationInfo, Exception e) throws ProvisioningDeviceClientException {
        if (this.provisioningDeviceClientRegistrationCallback == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Registration callback cannot be null"));
        }
        this.provisioningDeviceClientRegistrationCallback.run(registrationInfo, e, this.dpsRegistrationCallbackContext);
    }

    private RegistrationOperationStatusParser invokeRegister() throws InterruptedException, ExecutionException, TimeoutException, ProvisioningDeviceClientException {
        RegisterTask registerTask = new RegisterTask(this.provisioningDeviceClientConfig, this.securityProvider, this.provisioningDeviceClientContract, this.authorization);
        FutureTask<RegistrationOperationStatusParser> futureRegisterTask = new FutureTask<RegistrationOperationStatusParser>(registerTask);
        this.executor.submit(futureRegisterTask);
        RegistrationOperationStatusParser registrationOperationStatusParser = futureRegisterTask.get(1000000L, TimeUnit.MILLISECONDS);
        if (registrationOperationStatusParser == null) {
            this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ERROR;
            throw new ProvisioningDeviceClientAuthenticationException("Registration response could not be retrieved, authentication failure");
        }
        ProvisioningStatus status = ProvisioningStatus.fromString(registrationOperationStatusParser.getStatus());
        if (status == null) {
            this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ERROR;
            throw new ProvisioningDeviceClientAuthenticationException("Received null status for registration, authentication failure");
        }
        if (registrationOperationStatusParser.getOperationId() == null) {
            throw new ProvisioningDeviceClientAuthenticationException("operation id could not be retrieved, authentication failure");
        }
        return registrationOperationStatusParser;
    }

    private RegistrationOperationStatusParser invokeStatus(String operationId) throws TimeoutException, InterruptedException, ExecutionException, ProvisioningDeviceClientException {
        Thread.sleep(this.provisioningDeviceClientContract.getRetryValue());
        StatusTask statusTask = new StatusTask(this.securityProvider, this.provisioningDeviceClientContract, this.provisioningDeviceClientConfig, operationId, this.authorization);
        FutureTask<RegistrationOperationStatusParser> futureStatusTask = new FutureTask<RegistrationOperationStatusParser>(statusTask);
        this.executor.submit(futureStatusTask);
        RegistrationOperationStatusParser statusRegistrationOperationStatusParser = futureStatusTask.get(10000L, TimeUnit.MILLISECONDS);
        if (statusRegistrationOperationStatusParser == null) {
            this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ERROR;
            throw new ProvisioningDeviceClientAuthenticationException("Status response could not be retrieved, authentication failure");
        }
        if (statusRegistrationOperationStatusParser.getStatus() == null) {
            this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ERROR;
            throw new ProvisioningDeviceClientAuthenticationException("Status could not be retrieved, authentication failure");
        }
        if (ProvisioningStatus.fromString(statusRegistrationOperationStatusParser.getStatus()) == null) {
            this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ERROR;
            throw new ProvisioningDeviceClientAuthenticationException("Status could not be retrieved, authentication failure");
        }
        return statusRegistrationOperationStatusParser;
    }

    private void executeStateMachineForStatus(RegistrationOperationStatusParser registrationOperationStatusParser) throws TimeoutException, InterruptedException, ExecutionException, ProvisioningDeviceClientException, SecurityProviderException {
        boolean isContinue = false;
        ProvisioningStatus nextStatus = ProvisioningStatus.fromString(registrationOperationStatusParser.getStatus());
        log.info("Current provisioning status: {}", (Object)nextStatus);
        do {
            if (nextStatus == null) {
                throw new ProvisioningDeviceClientException("Did not receive a valid status");
            }
            switch (nextStatus) {
                case UNASSIGNED: 
                case ASSIGNING: {
                    log.trace("Polling device provisioning service for status of registration...");
                    registrationOperationStatusParser = this.invokeStatus(registrationOperationStatusParser.getOperationId());
                    nextStatus = ProvisioningStatus.fromString(registrationOperationStatusParser.getStatus());
                    isContinue = true;
                    break;
                }
                case ASSIGNED: {
                    this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ASSIGNED;
                    DeviceRegistrationResultParser registrationStatus = registrationOperationStatusParser.getRegistrationState();
                    if (registrationStatus == null || registrationStatus.getAssignedHub() == null || registrationStatus.getAssignedHub().isEmpty() || registrationStatus.getDeviceId() == null || registrationStatus.getDeviceId().isEmpty()) {
                        throw new ProvisioningDeviceClientException("Could not retrieve Assigned Hub or Device ID and status changed to Assigned");
                    }
                    RegistrationResult registrationInfo = new RegistrationResult(registrationStatus.getAssignedHub(), registrationStatus.getDeviceId(), registrationStatus.getPayload(), ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ASSIGNED);
                    registrationInfo.setRegistrationId(registrationStatus.getRegistrationId());
                    registrationInfo.setStatus(registrationStatus.getStatus());
                    registrationInfo.setSubstatus(ProvisioningDeviceClientSubstatus.fromString(registrationStatus.getSubstatus()));
                    registrationInfo.setCreatedDateTimeUtc(registrationStatus.getCreatedDateTimeUtc());
                    registrationInfo.setLastUpdatesDateTimeUtc(registrationStatus.getLastUpdatesDateTimeUtc());
                    registrationInfo.setETag(registrationStatus.getETag());
                    if (this.securityProvider instanceof SecurityProviderTpm) {
                        if (registrationStatus.getTpm() == null || registrationStatus.getTpm().getAuthenticationKey() == null || registrationStatus.getTpm().getAuthenticationKey().isEmpty()) {
                            throw new ProvisioningDeviceClientException("Could not retrieve Authentication key when status was assigned");
                        }
                        String authenticationKey = registrationStatus.getTpm().getAuthenticationKey();
                        ((SecurityProviderTpm)this.securityProvider).activateIdentityKey(Base64.decodeBase64((byte[])authenticationKey.getBytes(StandardCharsets.UTF_8)));
                    }
                    log.info("Device provisioning service assigned the device successfully");
                    this.invokeRegistrationCallback(registrationInfo, null);
                    isContinue = false;
                    break;
                }
                case FAILED: {
                    this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_FAILED;
                    String errorMessage = registrationOperationStatusParser.getRegistrationState().getErrorMessage();
                    ProvisioningDeviceHubException dpsHubException = new ProvisioningDeviceHubException(errorMessage);
                    if (registrationOperationStatusParser.getRegistrationState().getErrorCode() != null) {
                        dpsHubException.setErrorCode(registrationOperationStatusParser.getRegistrationState().getErrorCode());
                    }
                    RegistrationResult registrationInfo = new RegistrationResult(null, null, null, ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_FAILED);
                    log.error("Device provisioning service failed to provision the device, finished with status FAILED: {}", (Object)errorMessage);
                    this.invokeRegistrationCallback(registrationInfo, dpsHubException);
                    isContinue = false;
                    break;
                }
                case DISABLED: {
                    this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_DISABLED;
                    String disabledErrorMessage = registrationOperationStatusParser.getRegistrationState().getErrorMessage();
                    ProvisioningDeviceHubException dpsHubException = new ProvisioningDeviceHubException(disabledErrorMessage);
                    if (registrationOperationStatusParser.getRegistrationState().getErrorCode() != null) {
                        dpsHubException.setErrorCode(registrationOperationStatusParser.getRegistrationState().getErrorCode());
                    }
                    RegistrationResult registrationInfo = new RegistrationResult(null, null, null, ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_DISABLED);
                    log.error("Device provisioning service failed to provision the device, finished with status DISABLED: {}", (Object)disabledErrorMessage);
                    this.invokeRegistrationCallback(registrationInfo, dpsHubException);
                    isContinue = false;
                }
            }
        } while (isContinue);
    }

    @Override
    public Object call() throws Exception {
        String threadName = this.provisioningDeviceClientContract.getHostName() + "-" + this.provisioningDeviceClientConfig.getUniqueIdentifier() + "-CxnPendingConnectionId-" + THREAD_NAME;
        Thread.currentThread().setName(threadName);
        try {
            log.info("Opening the connection to device provisioning service...");
            this.provisioningDeviceClientContract.open(new RequestData(this.securityProvider.getRegistrationId(), this.securityProvider.getSSLContext(), this.securityProvider instanceof SecurityProviderX509, this.provisioningDeviceClientConfig.getPayload()));
            String connectionId = this.provisioningDeviceClientConfig.getUniqueIdentifier();
            if (connectionId == null) {
                connectionId = "PendingConnectionId";
            }
            threadName = this.provisioningDeviceClientContract.getHostName() + "-" + this.provisioningDeviceClientConfig.getUniqueIdentifier() + "-Cxn" + connectionId + "-" + THREAD_NAME;
            Thread.currentThread().setName(threadName);
            log.info("Connection to device provisioning service opened successfully, sending initial device registration message");
            RegistrationOperationStatusParser registrationOperationStatusParser = this.invokeRegister();
            log.info("Waiting for device provisioning service to provision this device...");
            this.executeStateMachineForStatus(registrationOperationStatusParser);
            this.close();
        }
        catch (ProvisioningDeviceClientException | SecurityProviderException | ExecutionException | TimeoutException e) {
            this.dpsStatus = ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ERROR;
            this.invokeRegistrationCallback(new RegistrationResult(null, null, null, ProvisioningDeviceClientStatus.PROVISIONING_DEVICE_STATUS_ERROR), (Exception)e);
            this.close();
        }
        return null;
    }

    private void close() throws ProvisioningDeviceConnectionException {
        this.provisioningDeviceClientContract.close();
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }
}

