/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.DeviceRegistrationResultParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.X509RegistrationResultParser;

public class RegistrationOperationStatusParser {
    private static final String OPERATION_ID = "operationId";
    @SerializedName(value="operationId")
    private String operationId;
    private static final String STATUS = "status";
    @SerializedName(value="status")
    private String status;
    private static final String REGISTRATION_STATE = "registrationState";
    @SerializedName(value="registrationState")
    private DeviceRegistrationResultParser registrationState;

    private RegistrationOperationStatusParser() {
    }

    public static RegistrationOperationStatusParser createFromJson(String json) throws IllegalArgumentException {
        RegistrationOperationStatusParser registrationOperationStatusParser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("JSON cannot be null or empty");
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        try {
            registrationOperationStatusParser = (RegistrationOperationStatusParser)gson.fromJson(json, RegistrationOperationStatusParser.class);
        }
        catch (JsonSyntaxException malformed) {
            throw new IllegalArgumentException("Malformed JSON", malformed);
        }
        if (registrationOperationStatusParser.operationId == null || registrationOperationStatusParser.status == null) {
            throw new IllegalArgumentException("JSON does not contain Operation Id or Status");
        }
        if (registrationOperationStatusParser.registrationState != null) {
            X509RegistrationResultParser.X509CertificateInfo X509CertificateInfo2;
            if (registrationOperationStatusParser.registrationState.getRegistrationId() == null) {
                throw new IllegalArgumentException("Registration Id cannot be null in the result");
            }
            if (registrationOperationStatusParser.registrationState.getStatus() == null) {
                throw new IllegalArgumentException("Status cannot be null in the result");
            }
            if (registrationOperationStatusParser.registrationState.getX509() != null && registrationOperationStatusParser.registrationState.getX509().getCertificateInfo() != null) {
                X509CertificateInfo2 = registrationOperationStatusParser.registrationState.getX509().getCertificateInfo();
                if (X509CertificateInfo2.getIssuerName() == null) {
                    throw new IllegalArgumentException("Issuer Name is required for X509 flow");
                }
                if (X509CertificateInfo2.getSubjectName() == null) {
                    throw new IllegalArgumentException("Subject Name is required for X509 flow");
                }
                if (X509CertificateInfo2.getSha1Thumbprint() == null) {
                    throw new IllegalArgumentException("SHA1 Thumbprint is required for X509 flow");
                }
                if (X509CertificateInfo2.getSha256Thumbprint() == null) {
                    throw new IllegalArgumentException("SHA256 Thumbprint is required for X509 flow");
                }
                if (X509CertificateInfo2.getNotBeforeUtc() == null) {
                    throw new IllegalArgumentException("Not before UTC time is required for X509 flow");
                }
                if (X509CertificateInfo2.getNotAfterUtc() == null) {
                    throw new IllegalArgumentException("Not After UTC is required for X509 flow");
                }
                if (X509CertificateInfo2.getSerialNumber() == null) {
                    throw new IllegalArgumentException("Serial Number is required for X509 flow");
                }
                if (X509CertificateInfo2.getVersion() == null) {
                    throw new IllegalArgumentException("Version is required for X509 flow");
                }
            }
            if (registrationOperationStatusParser.registrationState.getX509() != null && registrationOperationStatusParser.registrationState.getX509().getSigningCertificateInfo() != null) {
                X509CertificateInfo2 = registrationOperationStatusParser.registrationState.getX509().getSigningCertificateInfo();
                if (X509CertificateInfo2.getIssuerName() == null) {
                    throw new IllegalArgumentException("Issuer Name is required for X509 flow");
                }
                if (X509CertificateInfo2.getSubjectName() == null) {
                    throw new IllegalArgumentException("Subject Name is required for X509 flow");
                }
                if (X509CertificateInfo2.getSha1Thumbprint() == null) {
                    throw new IllegalArgumentException("SHA1 Thumbprint is required for X509 flow");
                }
                if (X509CertificateInfo2.getSha256Thumbprint() == null) {
                    throw new IllegalArgumentException("SHA256 Thumbprint is required for X509 flow");
                }
                if (X509CertificateInfo2.getNotBeforeUtc() == null) {
                    throw new IllegalArgumentException("Not before UTC time is required for X509 flow");
                }
                if (X509CertificateInfo2.getNotAfterUtc() == null) {
                    throw new IllegalArgumentException("Not After UTC is required for X509 flow");
                }
                if (X509CertificateInfo2.getSerialNumber() == null) {
                    throw new IllegalArgumentException("Serial Number is required for X509 flow");
                }
                if (X509CertificateInfo2.getVersion() == null) {
                    throw new IllegalArgumentException("Version is required for X509 flow");
                }
            }
        }
        return registrationOperationStatusParser;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getStatus() {
        return this.status;
    }

    public DeviceRegistrationResultParser getRegistrationState() {
        return this.registrationState;
    }
}

