/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;

public class DeviceRegistrationParser {
    private static final String REGISTRATION_ID = "registrationId";
    @SerializedName(value="registrationId")
    private String registrationId;
    private static final String TPM = "tpm";
    @SerializedName(value="tpm")
    private TpmAttestation tpmAttestation;
    private static final String CUSTOM_PAYLOAD = "payload";
    @SerializedName(value="payload")
    private String customPayload = null;

    DeviceRegistrationParser() {
    }

    public DeviceRegistrationParser(String registrationId, String customPayload) throws IllegalArgumentException {
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("Registration Id cannot be null or empty");
        }
        this.registrationId = registrationId;
        if (customPayload != null && !customPayload.isEmpty()) {
            this.customPayload = customPayload;
        }
    }

    public DeviceRegistrationParser(String registrationId, String customPayload, String endorsementKey, String storageRootKey) throws IllegalArgumentException {
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("Registration Id cannot be null or empty");
        }
        if (endorsementKey == null || endorsementKey.isEmpty()) {
            throw new IllegalArgumentException("endorsementKey cannot be null or empty");
        }
        this.registrationId = registrationId;
        if (customPayload != null && !customPayload.isEmpty()) {
            this.customPayload = customPayload;
        }
        this.tpmAttestation = new TpmAttestation(endorsementKey, storageRootKey);
    }

    public String toJson() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((Object)this);
    }

    static class TpmAttestation {
        private final String endorsementKey;
        private final String storageRootKey;

        TpmAttestation(String endorsementKey, String storageRootKey) {
            this.endorsementKey = endorsementKey;
            this.storageRootKey = storageRootKey;
        }
    }
}

