/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.mqtt;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.ObjectLock;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.SDKUtils;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ProvisioningDeviceClientContract;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceConnectionException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.DeviceRegistrationParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ContractState;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RequestData;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ResponseData;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttConnection;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttListener;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttMessage;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.mqtt.MqttQos;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLContext;

public class ContractAPIMqtt
extends ProvisioningDeviceClientContract
implements MqttListener {
    private static final String MQTT_USERNAME_FMT = "%s/registrations/%s/api-version=%s&ClientVersion=%s";
    private static final String MQTT_PROVISIONING_TOPIC_NAME = "$dps/registrations/res/#";
    private static final String MQTT_REGISTER_MESSAGE_FMT = "$dps/registrations/PUT/iotdps-register/?$rid=%d";
    private static final String MQTT_STATUS_MESSAGE_FMT = "$dps/registrations/GET/iotdps-get-operationstatus/?$rid=%d&operationId=%s";
    private static final int MAX_WAIT_TO_SEND_MSG = 60000;
    private MqttConnection mqttConnection;
    private final String hostname;
    private final String idScope;
    private int packetId;
    private final boolean useWebSockets;
    private final ObjectLock receiveLock = new ObjectLock();
    private final Queue<MqttMessage> receivedMessages = new LinkedBlockingQueue<MqttMessage>();
    private Throwable lostConnection = null;

    @Override
    public String getConnectionId() {
        if (this.mqttConnection != null) {
            return this.mqttConnection.getConnectionId();
        }
        return null;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    public ContractAPIMqtt(ProvisioningDeviceClientConfig provisioningDeviceClientConfig) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientConfig == null) {
            throw new ProvisioningDeviceClientException("ProvisioningDeviceClientConfig cannot be NULL.");
        }
        String idScope = provisioningDeviceClientConfig.getIdScope();
        if (idScope == null || idScope.isEmpty()) {
            throw new ProvisioningDeviceClientException("The idScope cannot be null or empty.");
        }
        String hostName = provisioningDeviceClientConfig.getProvisioningServiceGlobalEndpoint();
        if (hostName == null || hostName.isEmpty()) {
            throw new ProvisioningDeviceClientException("The hostName cannot be null or empty.");
        }
        this.useWebSockets = provisioningDeviceClientConfig.isUsingWebSocket();
        this.hostname = hostName;
        this.idScope = idScope;
        this.packetId = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeProvisioningMessage(String topic, byte[] body, ResponseCallback responseCallback, Object callbackContext) throws IOException, ProvisioningDeviceClientException {
        this.mqttConnection.publishMessage(topic, MqttQos.DELIVER_AT_MOST_ONCE, body);
        try {
            ObjectLock objectLock = this.receiveLock;
            synchronized (objectLock) {
                this.receiveLock.waitLock(60000L);
            }
            if (this.receivedMessages.size() <= 0) {
                throw new ProvisioningDeviceClientException("Invalid message received.");
            }
            MqttMessage message = this.receivedMessages.remove();
            responseCallback.run(new ResponseData(message.getPayload(), ContractState.DPS_REGISTRATION_RECEIVED, 0L), callbackContext);
        }
        catch (InterruptedException e) {
            throw new ProvisioningDeviceClientException("Provisioning service failed to reply is allotted time.");
        }
    }

    private void processRetryAfterValue(String mqttTopic) {
        if (mqttTopic != null && !mqttTopic.isEmpty()) {
            for (String topicPart : mqttTopic.split("&")) {
                int retryPosition = topicPart.indexOf("retry-after");
                if (retryPosition <= -1) continue;
                int topicSeparator = topicPart.indexOf(";");
                String targetRetryAfter = topicSeparator > -1 ? topicPart.substring("retry-after".length() + 1, topicSeparator) : topicPart.substring("retry-after".length() + 1);
                this.setRetrieveRetryAfterValue(targetRetryAfter);
                break;
            }
        }
    }

    @Override
    public synchronized void open(RequestData requestData) throws ProvisioningDeviceConnectionException {
        if (this.mqttConnection != null && !this.mqttConnection.isMqttConnected()) {
            throw new ProvisioningDeviceConnectionException("Open called on an already open connection");
        }
        if (requestData == null) {
            throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("RequestData cannot be null"));
        }
        String registrationId = requestData.getRegistrationId();
        if (registrationId == null || registrationId.isEmpty()) {
            throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("registration Id cannot be null or empty"));
        }
        SSLContext sslContext = requestData.getSslContext();
        if (sslContext == null) {
            throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("sslContext cannot be null"));
        }
        if (requestData.isX509() || requestData.getSasToken() != null && !requestData.getSasToken().isEmpty()) {
            try {
                String username = String.format(MQTT_USERNAME_FMT, this.idScope, registrationId, SDKUtils.getServiceApiVersion(), SDKUtils.getServiceApiVersion());
                this.mqttConnection = new MqttConnection(this.hostname, registrationId, username, requestData.getSasToken(), sslContext, this, this.useWebSockets);
                this.mqttConnection.connect();
                this.mqttConnection.subscribe(MQTT_PROVISIONING_TOPIC_NAME, MqttQos.DELIVER_AT_LEAST_ONCE);
            }
            catch (IOException ex) {
                this.mqttConnection = null;
                throw new ProvisioningDeviceConnectionException("Exception opening connection", ex);
            }
        }
    }

    @Override
    public synchronized void close() throws ProvisioningDeviceConnectionException {
        try {
            if (this.mqttConnection != null && this.mqttConnection.isMqttConnected()) {
                this.mqttConnection.disconnect();
            }
        }
        catch (IOException ex) {
            throw new ProvisioningDeviceConnectionException("Exception closing mqtt", ex);
        }
    }

    @Override
    public synchronized void authenticateWithProvisioningService(RequestData requestData, ResponseCallback responseCallback, Object callbackContext) throws ProvisioningDeviceClientException {
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        if (!requestData.isX509()) {
            String sasToken = requestData.getSasToken();
            if (sasToken == null || sasToken.isEmpty()) {
                throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("RequestData's sas token cannot be null or empty"));
            }
            this.open(requestData);
        }
        if (this.mqttConnection == null || !this.mqttConnection.isMqttConnected()) {
            throw new ProvisioningDeviceConnectionException("Mqtt is not connected");
        }
        try {
            String topic = String.format(MQTT_REGISTER_MESSAGE_FMT, this.packetId++);
            byte[] payload = new DeviceRegistrationParser(requestData.getRegistrationId(), requestData.getPayload()).toJson().getBytes(StandardCharsets.UTF_8);
            this.executeProvisioningMessage(topic, payload, responseCallback, callbackContext);
        }
        catch (IOException ex) {
            throw new ProvisioningDeviceConnectionException("Exception publishing mqtt message", ex);
        }
    }

    @Override
    public synchronized void getRegistrationStatus(RequestData requestData, ResponseCallback responseCallback, Object callbackContext) throws ProvisioningDeviceClientException {
        if (requestData == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("requestData cannot be null"));
        }
        String operationId = requestData.getOperationId();
        if (operationId == null || operationId.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("operationId cannot be null or empty"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        if (this.mqttConnection == null || !this.mqttConnection.isMqttConnected()) {
            throw new ProvisioningDeviceConnectionException("Mqtt is not connected");
        }
        if (this.lostConnection != null) {
            throw new ProvisioningDeviceConnectionException("Mqtt is not connected", this.lostConnection);
        }
        try {
            String topic = String.format(MQTT_STATUS_MESSAGE_FMT, this.packetId++, operationId);
            this.executeProvisioningMessage(topic, null, responseCallback, callbackContext);
        }
        catch (IOException ex) {
            throw new ProvisioningDeviceConnectionException("Exception publishing mqtt message", ex);
        }
    }

    @Override
    public synchronized void requestNonceForTPM(RequestData requestData, ResponseCallback responseCallback, Object authorizationCallbackContext) throws ProvisioningDeviceClientException {
        if (requestData == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("requestData cannot be null"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        String registrationId = requestData.getRegistrationId();
        if (registrationId == null || registrationId.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("registration Id cannot be null or empty"));
        }
        byte[] endorsementKey = requestData.getEndorsementKey();
        if (endorsementKey == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Endorsement key cannot be null"));
        }
        byte[] storageRootKey = requestData.getStorageRootKey();
        if (storageRootKey == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Storage root key cannot be null"));
        }
        if (requestData.getSslContext() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("sslContext cannot be null"));
        }
        throw new ProvisioningDeviceClientException(new UnsupportedOperationException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(MqttMessage message) {
        this.processRetryAfterValue(message.getTopic());
        this.receivedMessages.add(message);
        ObjectLock objectLock = this.receiveLock;
        synchronized (objectLock) {
            this.receiveLock.notifyLock();
        }
    }

    @Override
    public void connectionLost(Throwable throwable) {
        this.lostConnection = throwable;
    }
}

