/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.http;

import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientTransportProtocol;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.SDKUtils;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ProvisioningDeviceClientContract;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.UrlPathBuilder;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientExceptionManager;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceConnectionException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceHubException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceTransportException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.DeviceRegistrationParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.TpmRegistrationResultParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ContractState;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RequestData;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ResponseData;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.https.HttpMethod;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.https.HttpRequest;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.https.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractAPIHttp
extends ProvisioningDeviceClientContract {
    private static final Logger log = LoggerFactory.getLogger(ContractAPIHttp.class);
    private final String idScope;
    private final String hostName;
    private static final String AUTHORIZATION = "authorization";
    private static final String USER_AGENT = "User-Agent";
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_VALUE = "application/json";
    private static final String ACCEPT_CHARSET = "charset=utf-8";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String USER_AGENT_VALUE = "com.microsoft.azure.sdk.iot.dps.dps-device-client/" + SDKUtils.PROVISIONING_DEVICE_CLIENT_VERSION;
    private static final Integer DEFAULT_HTTP_TIMEOUT_MS = Integer.MAX_VALUE;
    private static final Integer ACCEPTABLE_NONCE_HTTP_STATUS = 401;

    @Override
    public void open(RequestData requestData) {
    }

    @Override
    public String getConnectionId() {
        return "HTTP";
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void close() throws ProvisioningDeviceConnectionException {
    }

    public ContractAPIHttp(ProvisioningDeviceClientConfig provisioningDeviceClientConfig) throws ProvisioningDeviceClientException {
        String idScope = provisioningDeviceClientConfig.getIdScope();
        if (idScope == null || idScope.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("scope id cannot be null or empty"));
        }
        String hostName = provisioningDeviceClientConfig.getProvisioningServiceGlobalEndpoint();
        if (hostName == null || hostName.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("host name cannot be null or empty"));
        }
        this.idScope = idScope;
        this.hostName = hostName;
    }

    private HttpRequest prepareRequest(URL url, HttpMethod method, byte[] payload, Map<String, String> headersMap) throws IllegalArgumentException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null URL");
        }
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        if (payload == null) {
            throw new IllegalArgumentException("Null payload");
        }
        if (DEFAULT_HTTP_TIMEOUT_MS < 0) {
            throw new IllegalArgumentException("HTTP Request timeout shouldn't be negative");
        }
        HttpRequest request = new HttpRequest(url, method, payload);
        request.setHeaderField(USER_AGENT, USER_AGENT_VALUE);
        request.setHeaderField(ACCEPT, ACCEPT_VALUE);
        request.setHeaderField(CONTENT_TYPE, "application/json; charset=utf-8");
        request.setHeaderField(CONTENT_LENGTH, String.valueOf(payload.length));
        if (headersMap != null) {
            for (Map.Entry<String, String> header : headersMap.entrySet()) {
                request.setHeaderField(header.getKey(), header.getValue());
            }
        }
        return request;
    }

    private HttpResponse sendRequest(HttpRequest request) throws ProvisioningDeviceHubException, IOException {
        HttpResponse response = request.send();
        log.trace("Provisioning device client received http response with status {}", (Object)response.getStatus());
        ProvisioningDeviceClientExceptionManager.verifyHttpResponse(response);
        return response;
    }

    private void processRetryAfterValue(HttpResponse httpResponse) {
        if (httpResponse.isFieldAvailable("retry-after")) {
            this.setRetrieveRetryAfterValue(httpResponse.getHeaderField("retry-after"));
        }
    }

    @Override
    public synchronized void requestNonceForTPM(RequestData requestData, ResponseCallback responseCallback, Object dpsAuthorizationCallbackContext) throws ProvisioningDeviceClientException {
        if (requestData.getRegistrationId() == null || requestData.getRegistrationId().isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("registration Id cannot be null or empty"));
        }
        if (requestData.getEndorsementKey() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Endorsement key cannot be null"));
        }
        if (requestData.getStorageRootKey() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Storage root key cannot be null"));
        }
        if (requestData.getSslContext() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("sslContext cannot be null"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("responseCallback cannot be null"));
        }
        try {
            String url = new UrlPathBuilder(this.hostName, this.idScope, ProvisioningDeviceClientTransportProtocol.HTTPS).generateRegisterUrl(requestData.getRegistrationId());
            String base64EncodedEk = new String(Base64.encodeBase64((byte[])requestData.getEndorsementKey()), StandardCharsets.UTF_8);
            String base64EncodedSrk = new String(Base64.encodeBase64((byte[])requestData.getStorageRootKey()), StandardCharsets.UTF_8);
            byte[] payload = new DeviceRegistrationParser(requestData.getRegistrationId(), requestData.getPayload(), base64EncodedEk, base64EncodedSrk).toJson().getBytes(StandardCharsets.UTF_8);
            HttpRequest httpRequest = this.prepareRequest(new URL(url), HttpMethod.PUT, payload, null);
            httpRequest.setSSLContext(requestData.getSslContext());
            HttpResponse httpResponse = null;
            try {
                httpResponse = httpRequest.send();
                ProvisioningDeviceClientExceptionManager.verifyHttpResponse(httpResponse);
            }
            catch (ProvisioningDeviceHubException e) {
                if (httpResponse.getStatus() == ACCEPTABLE_NONCE_HTTP_STATUS.intValue()) {
                    String tpmRegistrationResultJson = new String(httpResponse.getErrorReason(), StandardCharsets.UTF_8);
                    TpmRegistrationResultParser registerResponseTPMParser = TpmRegistrationResultParser.createFromJson(tpmRegistrationResultJson);
                    byte[] base64DecodedAuthKey = Base64.decodeBase64((byte[])registerResponseTPMParser.getAuthenticationKey().getBytes(StandardCharsets.UTF_8));
                    responseCallback.run(new ResponseData(base64DecodedAuthKey, ContractState.DPS_REGISTRATION_RECEIVED, 0L), dpsAuthorizationCallbackContext);
                    return;
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new ProvisioningDeviceTransportException(e);
        }
        throw new ProvisioningDeviceTransportException("Service did not return any authorization request");
    }

    @Override
    public synchronized void authenticateWithProvisioningService(RequestData requestData, ResponseCallback responseCallback, Object dpsAuthorizationCallbackContext) throws ProvisioningDeviceClientException {
        if (requestData.getRegistrationId() == null || requestData.getRegistrationId().isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("registration Id cannot be null or empty"));
        }
        if (requestData.getSslContext() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("sslContext cannot be null"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("responseCallback cannot be null"));
        }
        try {
            byte[] payload;
            String url = new UrlPathBuilder(this.hostName, this.idScope, ProvisioningDeviceClientTransportProtocol.HTTPS).generateRegisterUrl(requestData.getRegistrationId());
            HashMap<String, String> headersMap = null;
            if (requestData.getSasToken() != null) {
                headersMap = new HashMap<String, String>();
                headersMap.put(AUTHORIZATION, requestData.getSasToken());
            }
            if (requestData.getEndorsementKey() != null && requestData.getStorageRootKey() != null) {
                String base64EncodedEk = new String(Base64.encodeBase64((byte[])requestData.getEndorsementKey()), StandardCharsets.UTF_8);
                String base64EncodedSrk = new String(Base64.encodeBase64((byte[])requestData.getStorageRootKey()), StandardCharsets.UTF_8);
                payload = new DeviceRegistrationParser(requestData.getRegistrationId(), requestData.getPayload(), base64EncodedEk, base64EncodedSrk).toJson().getBytes(StandardCharsets.UTF_8);
            } else {
                payload = new DeviceRegistrationParser(requestData.getRegistrationId(), requestData.getPayload()).toJson().getBytes(StandardCharsets.UTF_8);
            }
            HttpRequest httpRequest = this.prepareRequest(new URL(url), HttpMethod.PUT, payload, headersMap);
            httpRequest.setSSLContext(requestData.getSslContext());
            HttpResponse httpResponse = this.sendRequest(httpRequest);
            this.processRetryAfterValue(httpResponse);
            responseCallback.run(new ResponseData(httpResponse.getBody(), ContractState.DPS_REGISTRATION_RECEIVED, 0L), dpsAuthorizationCallbackContext);
        }
        catch (IOException e) {
            throw new ProvisioningDeviceTransportException(e);
        }
    }

    @Override
    public synchronized void getRegistrationStatus(RequestData requestData, ResponseCallback responseCallback, Object dpsAuthorizationCallbackContext) throws ProvisioningDeviceClientException {
        if (requestData.getOperationId() == null || requestData.getOperationId().isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("operationId cannot be null or empty"));
        }
        if (requestData.getRegistrationId() == null || requestData.getRegistrationId().isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("registration Id cannot be null or empty"));
        }
        if (requestData.getSslContext() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("sslContext cannot be null"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("responseCallback cannot be null"));
        }
        try {
            String url = new UrlPathBuilder(this.hostName, this.idScope, ProvisioningDeviceClientTransportProtocol.HTTPS).generateRequestUrl(requestData.getRegistrationId(), requestData.getOperationId());
            HashMap<String, String> headersMap = null;
            if (requestData.getSasToken() != null) {
                headersMap = new HashMap<String, String>();
                headersMap.put(AUTHORIZATION, requestData.getSasToken());
            }
            HttpRequest httpRequest = this.prepareRequest(new URL(url), HttpMethod.GET, new byte[0], headersMap);
            httpRequest.setSSLContext(requestData.getSslContext());
            HttpResponse httpResponse = this.sendRequest(httpRequest);
            this.processRetryAfterValue(httpResponse);
            responseCallback.run(new ResponseData(httpResponse.getBody(), ContractState.DPS_REGISTRATION_RECEIVED, 0L), dpsAuthorizationCallbackContext);
        }
        catch (IOException e) {
            throw new ProvisioningDeviceTransportException(e);
        }
    }
}

