/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.ObjectLock;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.SDKUtils;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceConnectionException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceTransportException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ContractState;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ResponseData;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.AmqpDeviceOperations;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.AmqpListener;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.AmqpMessage;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.AmqpsConnection;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.SaslHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLContext;

class ProvisioningAmqpOperations
extends AmqpDeviceOperations
implements AmqpListener {
    private static final String AMQP_ADDRESS_FMT = "/%s/registrations/%s";
    private static final String AMQP_REGISTER_DEVICE = "iotdps-register";
    private static final String AMQP_OPERATION_STATUS = "iotdps-get-operationstatus";
    private static final String AMQP_OP_TYPE_PROPERTY = "iotdps-operation-type";
    private static final String AMQP_OPERATION_ID = "iotdps-operation-id";
    private static final String API_VERSION_KEY = "com.microsoft:api-version";
    private static final String CLIENT_VERSION_IDENTIFIER_KEY = "com.microsoft:client-version";
    private static final int MAX_WAIT_TO_SEND_MSG = 60000;
    private static final long MAX_WAIT_TO_OPEN_AMQP_CONNECTION = 60000L;
    private AmqpsConnection amqpConnection;
    private final Queue<AmqpMessage> receivedMessages = new LinkedBlockingQueue<AmqpMessage>();
    private final ObjectLock receiveLock = new ObjectLock();
    private Map<String, Object> messageAppProperties;
    private final String idScope;
    private final String hostName;
    private String messageSendFailedExceptionMessage;

    ProvisioningAmqpOperations(String idScope, String hostName) throws ProvisioningDeviceClientException {
        if (idScope == null || idScope.isEmpty()) {
            throw new ProvisioningDeviceClientException("The idScope cannot be null or empty.");
        }
        if (hostName == null || hostName.isEmpty()) {
            throw new ProvisioningDeviceClientException("The hostName cannot be null or empty.");
        }
        this.idScope = idScope;
        this.hostName = hostName;
    }

    private synchronized void sendAmqpMessage(String msgType, String operationId, byte[] msgBody) throws ProvisioningDeviceClientException {
        try {
            AmqpMessage outgoingMessage = new AmqpMessage();
            HashMap<String, Object> userProperties = new HashMap<String, Object>();
            userProperties.put(AMQP_OP_TYPE_PROPERTY, msgType);
            if (operationId != null && !operationId.isEmpty()) {
                userProperties.put(AMQP_OPERATION_ID, operationId);
            }
            outgoingMessage.setApplicationProperty(userProperties);
            if (msgBody != null && msgBody.length > 0) {
                outgoingMessage.setBody(msgBody);
            }
            this.amqpConnection.sendAmqpMessage(outgoingMessage);
        }
        catch (Exception e) {
            throw new ProvisioningDeviceTransportException("Failure sending AMQP message", e);
        }
    }

    private void retrieveAmqpMessage(ResponseCallback responseCallback, Object callbackContext) throws ProvisioningDeviceClientException {
        if (this.receivedMessages.size() > 0) {
            AmqpMessage message = this.receivedMessages.remove();
            this.messageAppProperties = message.getApplicationProperty();
            byte[] msgData = message.getAmqpBody();
            if (msgData != null) {
                responseCallback.run(new ResponseData(msgData, ContractState.DPS_REGISTRATION_RECEIVED, 0L), callbackContext);
            }
        }
    }

    public boolean isAmqpConnected() throws ProvisioningDeviceClientException {
        boolean isConnected = false;
        if (this.amqpConnection != null) {
            try {
                isConnected = this.amqpConnection.isConnected();
            }
            catch (Exception e) {
                throw new ProvisioningDeviceConnectionException(e);
            }
        }
        return isConnected;
    }

    public void open(String registrationId, SSLContext sslContext, SaslHandler saslHandler, boolean useWebSockets) throws ProvisioningDeviceConnectionException {
        try {
            if (this.amqpConnection == null || !this.amqpConnection.isConnected()) {
                if (registrationId == null || registrationId.isEmpty()) {
                    throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("registration Id cannot be null or empty"));
                }
                if (sslContext == null) {
                    throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("sslContext cannot be null"));
                }
                this.addAmqpLinkProperty(API_VERSION_KEY, SDKUtils.getServiceApiVersion());
                this.addAmqpLinkProperty(CLIENT_VERSION_IDENTIFIER_KEY, SDKUtils.getUserAgentString());
                this.amqpLinkAddress = String.format(AMQP_ADDRESS_FMT, this.idScope, registrationId);
                this.amqpConnection = new AmqpsConnection(this.hostName, this, sslContext, saslHandler, useWebSockets);
                this.amqpConnection.setListener(this);
                if (saslHandler != null) {
                    this.amqpConnection.openAmqpAsync();
                } else {
                    this.amqpConnection.open();
                }
            }
        }
        catch (Exception ex) {
            throw new ProvisioningDeviceConnectionException("Failure opening amqp connection", ex);
        }
    }

    public void close() throws IOException {
        if (this.amqpConnection != null) {
            this.amqpConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStatusMessage(String operationId, ResponseCallback responseCallback, Object callbackContext) throws ProvisioningDeviceClientException {
        if (operationId == null || operationId.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("operationId cannot be null or empty"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        this.sendAmqpMessage(AMQP_OPERATION_STATUS, operationId, null);
        try {
            ObjectLock objectLock = this.receiveLock;
            synchronized (objectLock) {
                this.receiveLock.waitLock(60000L);
            }
            if (this.messageSendFailedExceptionMessage != null) {
                throw new ProvisioningDeviceClientException("Failed to send amqp message to check provisioning status: " + this.messageSendFailedExceptionMessage);
            }
            this.retrieveAmqpMessage(responseCallback, callbackContext);
        }
        catch (InterruptedException e) {
            throw new ProvisioningDeviceClientException("Provisioning service failed to reply is allotted time.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRegisterMessage(ResponseCallback responseCallback, Object callbackContext, byte[] msgBody) throws ProvisioningDeviceClientException {
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        long millisecondsElapsed = 0L;
        long waitStartTime = System.currentTimeMillis();
        try {
            while (!this.amqpConnection.isConnected() && millisecondsElapsed < 60000L) {
                Thread.sleep(1000L);
                millisecondsElapsed = System.currentTimeMillis() - waitStartTime;
            }
        }
        catch (Exception e) {
            throw new ProvisioningDeviceClientException("Provisioning device client encountered an exception while waiting for amqps connection to open.", e);
        }
        if (millisecondsElapsed >= 60000L) {
            throw new ProvisioningDeviceClientException("Provisioning device client timed out while waiting for amqps connection to open.");
        }
        this.sendAmqpMessage(AMQP_REGISTER_DEVICE, null, msgBody);
        try {
            ObjectLock e = this.receiveLock;
            synchronized (e) {
                this.receiveLock.waitLock(60000L);
            }
            if (this.messageSendFailedExceptionMessage != null) {
                throw new ProvisioningDeviceClientException("Failed to send amqp message to register device: " + this.messageSendFailedExceptionMessage);
            }
            this.retrieveAmqpMessage(responseCallback, callbackContext);
        }
        catch (InterruptedException e) {
            throw new ProvisioningDeviceClientException("Provisioning service failed to reply is allotted time.");
        }
    }

    public Map<String, Object> getAmqpMessageProperties() {
        return this.messageAppProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(AmqpMessage message) {
        this.receivedMessages.add(message);
        ObjectLock objectLock = this.receiveLock;
        synchronized (objectLock) {
            this.receiveLock.notifyLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageSendFailed(String exceptionMessage) {
        this.messageSendFailedExceptionMessage = exceptionMessage;
        ObjectLock objectLock = this.receiveLock;
        synchronized (objectLock) {
            this.receiveLock.notifyLock();
        }
    }

    public String getConnectionId() {
        if (this.amqpConnection != null) {
            return this.amqpConnection.getConnectionId();
        }
        return null;
    }

    public String getHostName() {
        if (this.amqpConnection != null) {
            return this.amqpConnection.getHostName();
        }
        return null;
    }
}

