/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ProvisioningDeviceClientContract;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp.AmqpsProvisioningSaslHandler;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp.AmqpsProvisioningSymmetricKeySaslHandler;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp.ProvisioningAmqpOperations;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceConnectionException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.parser.DeviceRegistrationParser;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RequestData;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.SaslHandler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class ContractAPIAmqp
extends ProvisioningDeviceClientContract {
    private final ProvisioningAmqpOperations provisioningAmqpOperations;
    private final boolean useWebSockets;
    private final String idScope;
    private final String hostName;
    private SaslHandler amqpSaslHandler;

    private void processRetryAfterValue(Map<String, Object> appProperties) {
        if (appProperties != null && appProperties.containsKey("retry-after")) {
            Object retryAfterValue = appProperties.get("retry-after");
            this.setRetrieveRetryAfterValue(retryAfterValue.toString());
        }
    }

    public ContractAPIAmqp(ProvisioningDeviceClientConfig provisioningDeviceClientConfig) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientConfig == null) {
            throw new ProvisioningDeviceClientException("ProvisioningDeviceClientConfig cannot be NULL.");
        }
        this.idScope = provisioningDeviceClientConfig.getIdScope();
        if (this.idScope == null || this.idScope.isEmpty()) {
            throw new ProvisioningDeviceClientException("The idScope cannot be null or empty.");
        }
        String hostName = provisioningDeviceClientConfig.getProvisioningServiceGlobalEndpoint();
        if (hostName == null || hostName.isEmpty()) {
            throw new ProvisioningDeviceClientException("The hostName cannot be null or empty.");
        }
        this.hostName = hostName;
        this.useWebSockets = provisioningDeviceClientConfig.isUsingWebSocket();
        this.provisioningAmqpOperations = new ProvisioningAmqpOperations(this.idScope, hostName);
    }

    @Override
    public synchronized void open(RequestData requestData) throws ProvisioningDeviceConnectionException {
        if (requestData == null) {
            throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("requestData cannot be null"));
        }
        if (requestData.isX509()) {
            String registrationId = requestData.getRegistrationId();
            if (registrationId == null || registrationId.isEmpty()) {
                throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("registration Id cannot be null or empty"));
            }
            SSLContext sslContext = requestData.getSslContext();
            if (sslContext == null) {
                throw new ProvisioningDeviceConnectionException(new IllegalArgumentException("sslContext cannot be null"));
            }
            this.provisioningAmqpOperations.open(registrationId, sslContext, this.amqpSaslHandler, this.useWebSockets);
        }
    }

    @Override
    public synchronized void requestNonceForTPM(RequestData requestData, ResponseCallback responseCallback, Object authorizationCallbackContext) throws ProvisioningDeviceClientException {
        if (requestData == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("requestData cannot be null"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        String registrationId = requestData.getRegistrationId();
        if (registrationId == null || registrationId.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("registration Id cannot be null or empty"));
        }
        byte[] endorsementKey = requestData.getEndorsementKey();
        if (endorsementKey == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Endorsement key cannot be null"));
        }
        byte[] storageRootKey = requestData.getStorageRootKey();
        if (storageRootKey == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("Storage root key cannot be null"));
        }
        if (requestData.getSslContext() == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("sslContext cannot be null"));
        }
        SSLContext sslContext = requestData.getSslContext();
        this.amqpSaslHandler = new AmqpsProvisioningSaslHandler(this.idScope, requestData.getRegistrationId(), requestData.getEndorsementKey(), requestData.getStorageRootKey(), responseCallback, authorizationCallbackContext);
        this.provisioningAmqpOperations.open(registrationId, sslContext, this.amqpSaslHandler, this.useWebSockets);
    }

    @Override
    public synchronized void authenticateWithProvisioningService(RequestData requestData, ResponseCallback responseCallback, Object callbackContext) throws ProvisioningDeviceClientException {
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        if (!requestData.isX509() && this.amqpSaslHandler == null) {
            this.amqpSaslHandler = new AmqpsProvisioningSymmetricKeySaslHandler(this.idScope, requestData.getRegistrationId(), requestData.getSasToken());
            this.provisioningAmqpOperations.open(requestData.getRegistrationId(), requestData.getSslContext(), this.amqpSaslHandler, this.useWebSockets);
        }
        if (this.amqpSaslHandler != null) {
            this.amqpSaslHandler.setSasToken(requestData.getSasToken());
        }
        byte[] payload = new DeviceRegistrationParser(requestData.getRegistrationId(), requestData.getPayload()).toJson().getBytes(StandardCharsets.UTF_8);
        this.provisioningAmqpOperations.sendRegisterMessage(responseCallback, callbackContext, payload);
        this.processRetryAfterValue(this.provisioningAmqpOperations.getAmqpMessageProperties());
    }

    @Override
    public synchronized void getRegistrationStatus(RequestData requestData, ResponseCallback responseCallback, Object callbackContext) throws ProvisioningDeviceClientException {
        if (requestData == null) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("requestData cannot be null"));
        }
        String operationId = requestData.getOperationId();
        if (operationId == null || operationId.isEmpty()) {
            throw new ProvisioningDeviceClientException(new IllegalArgumentException("operationId cannot be null or empty"));
        }
        if (responseCallback == null) {
            throw new ProvisioningDeviceClientException("responseCallback cannot be null");
        }
        try {
            if (!this.provisioningAmqpOperations.isAmqpConnected()) {
                throw new ProvisioningDeviceConnectionException("Amqp is not connected");
            }
        }
        catch (Exception e) {
            throw new ProvisioningDeviceClientException(e);
        }
        this.provisioningAmqpOperations.sendStatusMessage(operationId, responseCallback, callbackContext);
    }

    @Override
    public synchronized void close() throws ProvisioningDeviceConnectionException {
        try {
            this.provisioningAmqpOperations.close();
        }
        catch (IOException ex) {
            throw new ProvisioningDeviceConnectionException("Closing amqp failed", ex);
        }
    }

    @Override
    public String getConnectionId() {
        if (this.provisioningAmqpOperations != null) {
            return this.provisioningAmqpOperations.getConnectionId();
        }
        return null;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }
}

