/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceSecurityException;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.SaslHandler;

class AmqpsProvisioningSymmetricKeySaslHandler
implements SaslHandler {
    private static final String PLAIN_MECHANISM = "PLAIN";
    private static final String USERNAME_FORMAT = "%s/registrations/%s";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final String idScope;
    private final String registrationId;
    private String sasToken;

    AmqpsProvisioningSymmetricKeySaslHandler(String idScope, String registrationId, String sasToken) {
        if (idScope == null || idScope.isEmpty()) {
            throw new IllegalArgumentException("IdScope cannot be null or empty");
        }
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("RegistrationId cannot be null or empty");
        }
        if (sasToken == null || sasToken.isEmpty()) {
            throw new IllegalArgumentException("sasToken cannot be null or empty");
        }
        this.idScope = idScope;
        this.registrationId = registrationId;
        this.sasToken = sasToken;
    }

    @Override
    public String chooseSaslMechanism(String[] mechanisms) throws ProvisioningDeviceSecurityException {
        for (String mechanism : mechanisms) {
            if (!PLAIN_MECHANISM.equals(mechanism)) continue;
            return PLAIN_MECHANISM;
        }
        throw new ProvisioningDeviceSecurityException("Service endpoint does not support TPM authentication");
    }

    @Override
    public byte[] getInitPayload(String chosenMechanism) {
        return EMPTY_BYTE_ARRAY;
    }

    @Override
    public byte[] handleChallenge(byte[] saslChallenge) {
        return new byte[0];
    }

    @Override
    public void handleOutcome(SaslHandler.SaslOutcome outcome) throws ProvisioningDeviceSecurityException {
        switch (outcome) {
            case OK: {
                break;
            }
            case AUTH: {
                throw new ProvisioningDeviceSecurityException("Sas token was rejected by the service");
            }
            case SYS_TEMP: {
                throw new ProvisioningDeviceSecurityException("Sasl negotiation failed due to transient system error");
            }
            default: {
                throw new ProvisioningDeviceSecurityException("Sasl negotiation with service failed");
            }
        }
    }

    @Override
    public String getPlainUsername() {
        return String.format(USERNAME_FORMAT, this.idScope, this.registrationId);
    }

    @Override
    public String getPlainPassword() {
        return this.sasToken;
    }

    @Override
    public void setSasToken(String sasToken) {
        this.sasToken = sasToken;
    }
}

