/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceSecurityException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ContractState;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ResponseData;
import com.microsoft.azure.sdk.iot.provisioning.device.transport.amqp.SaslHandler;
import java.nio.charset.StandardCharsets;

class AmqpsProvisioningSaslHandler
implements SaslHandler {
    private static final String TPM_MECHANISM = "TPM";
    private static final byte NULL_BYTE = 0;
    private static final byte INIT_SEGMENT_CONTROL_BYTE = 0;
    private static final byte INTERMEDIATE_SEGMENT_CONTROL_BYTE = -128;
    private static final byte FINAL_SEGMENT_CONTROL_BYTE = -63;
    private static final long MAX_MILLISECONDS_TIMEOUT_FOR_SAS_TOKEN_WAIT = 60000L;
    private static final long WAIT_INTERVALS = 4000L;
    private final String idScope;
    private final String registrationId;
    private final byte[] endorsementKey;
    private final byte[] storageRootKey;
    private byte[] challengeKey;
    private ChallengeState challengeState;
    private final ResponseCallback responseCallback;
    private final Object authorizationCallbackContext;
    private String sasToken;

    AmqpsProvisioningSaslHandler(String idScope, String registrationId, byte[] endorsementKey, byte[] storageRootKey, ResponseCallback responseCallback, Object authorizationCallbackContext) {
        if (idScope == null || idScope.isEmpty()) {
            throw new IllegalArgumentException("IdScope cannot be null or empty");
        }
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("RegistrationId cannot be null or empty");
        }
        if (endorsementKey == null || endorsementKey.length == 0) {
            throw new IllegalArgumentException("Endorsement Key cannot be null or empty");
        }
        if (storageRootKey == null || storageRootKey.length == 0) {
            throw new IllegalArgumentException("Storage root key cannot be null or empty");
        }
        if (responseCallback == null) {
            throw new IllegalArgumentException("responseCallback cannot be null");
        }
        this.idScope = idScope;
        this.registrationId = registrationId;
        this.endorsementKey = endorsementKey;
        this.storageRootKey = storageRootKey;
        this.responseCallback = responseCallback;
        this.authorizationCallbackContext = authorizationCallbackContext;
        this.challengeState = ChallengeState.WAITING_FOR_MECHANISMS;
        this.sasToken = null;
    }

    @Override
    public String chooseSaslMechanism(String[] mechanisms) throws ProvisioningDeviceSecurityException {
        if (this.challengeState != ChallengeState.WAITING_FOR_MECHANISMS) {
            throw new IllegalStateException("Handler is not in a state to handle choosing a mechanism");
        }
        boolean tpmMechanismOfferedByService = false;
        for (String mechanism : mechanisms) {
            tpmMechanismOfferedByService |= mechanism.equals(TPM_MECHANISM);
        }
        if (!tpmMechanismOfferedByService) {
            throw new ProvisioningDeviceSecurityException("Service endpoint does not support TPM authentication");
        }
        this.challengeState = ChallengeState.WAITING_TO_BUILD_INIT;
        return TPM_MECHANISM;
    }

    @Override
    public byte[] getInitPayload(String chosenMechanism) {
        if (this.challengeState != ChallengeState.WAITING_TO_BUILD_INIT) {
            throw new IllegalStateException("Handler is not in a state to build the init payload");
        }
        byte[] saslInitBytes = AmqpsProvisioningSaslHandler.buildSaslInitPayload(this.idScope, this.registrationId, this.endorsementKey);
        this.challengeState = ChallengeState.WAITING_FOR_FIRST_CHALLENGE;
        return saslInitBytes;
    }

    @Override
    public byte[] handleChallenge(byte[] saslChallenge) throws ProvisioningDeviceClientException {
        if (saslChallenge == null) {
            throw new IllegalArgumentException("Challenge data cannot be null");
        }
        switch (this.challengeState) {
            case WAITING_FOR_FIRST_CHALLENGE: {
                this.challengeState = ChallengeState.WAITING_FOR_SECOND_CHALLENGE;
                return this.handleFirstChallenge(saslChallenge);
            }
            case WAITING_FOR_SECOND_CHALLENGE: {
                return this.handleSecondChallenge(saslChallenge);
            }
            case WAITING_FOR_THIRD_CHALLENGE: {
                return this.handleThirdChallenge(saslChallenge);
            }
            case WAITING_FOR_MECHANISMS: {
                throw new IllegalStateException("Unexpected challenge received when expecting to choose sasl mechanism");
            }
            case WAITING_TO_BUILD_INIT: {
                throw new IllegalStateException("Unexpected challenge received when expecting to build sasl init payload");
            }
            case WAITING_TO_SEND_SAS_TOKEN: {
                throw new IllegalStateException("Unexpected challenge received when expecting to send sas token");
            }
            case WAITING_FOR_FINAL_OUTCOME: {
                throw new IllegalStateException("Unexpected challenge received when expecting Sasl outcome");
            }
        }
        throw new IllegalStateException("Unexpected challenge received");
    }

    @Override
    public void handleOutcome(SaslHandler.SaslOutcome outcome) throws ProvisioningDeviceSecurityException {
        if (this.challengeState != ChallengeState.WAITING_FOR_FINAL_OUTCOME) {
            throw new IllegalStateException("This handler is not ready to handle the sasl outcome");
        }
        switch (outcome) {
            case OK: {
                break;
            }
            case AUTH: {
                throw new ProvisioningDeviceSecurityException("Sas token was rejected by the service");
            }
            case SYS_TEMP: {
                throw new ProvisioningDeviceSecurityException("Sasl negotiation failed due to transient system error");
            }
            default: {
                throw new ProvisioningDeviceSecurityException("Sasl negotiation with service failed");
            }
        }
    }

    @Override
    public String getPlainUsername() {
        throw new UnsupportedOperationException("TPM sasl does not use plain mechanism for authentication");
    }

    @Override
    public String getPlainPassword() {
        throw new UnsupportedOperationException("TPM sasl does not use plain mechanism for authentication");
    }

    @Override
    public void setSasToken(String sasToken) {
        this.sasToken = sasToken;
    }

    private byte[] handleFirstChallenge(byte[] challengeData) {
        if (challengeData.length != 1 || challengeData[0] != 0) {
            throw new IllegalStateException("Unexpected challenge data");
        }
        return AmqpsProvisioningSaslHandler.buildFirstSaslChallengeResponsePayload(this.storageRootKey);
    }

    private byte[] handleSecondChallenge(byte[] challengeData) {
        if (challengeData.length < 1 || challengeData[0] != -128) {
            throw new IllegalStateException("Unexpected challenge data");
        }
        this.challengeState = ChallengeState.WAITING_FOR_THIRD_CHALLENGE;
        this.challengeKey = new byte[challengeData.length - 1];
        System.arraycopy(challengeData, 1, this.challengeKey, 0, challengeData.length - 1);
        return new byte[]{0};
    }

    private byte[] handleThirdChallenge(byte[] challengeData) throws ProvisioningDeviceClientException {
        if (challengeData.length < 1 || challengeData[0] != -63) {
            throw new IllegalStateException("Unexpected challenge data");
        }
        this.challengeKey = this.buildNonceFromThirdChallenge(challengeData);
        this.responseCallback.run(new ResponseData(this.challengeKey, ContractState.DPS_REGISTRATION_RECEIVED, 0L), this.authorizationCallbackContext);
        this.challengeState = ChallengeState.WAITING_TO_SEND_SAS_TOKEN;
        long millisecondsElapsed = 0L;
        long waitTimeStart = System.currentTimeMillis();
        while (this.sasToken == null && millisecondsElapsed < 60000L) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                throw new ProvisioningDeviceClientException(e);
            }
            millisecondsElapsed = System.currentTimeMillis() - waitTimeStart;
        }
        if (millisecondsElapsed >= 60000L) {
            throw new ProvisioningDeviceSecurityException("Sasl negotiation failed: Sas token was never supplied to finish negotiation");
        }
        this.challengeState = ChallengeState.WAITING_FOR_FINAL_OUTCOME;
        return AmqpsProvisioningSaslHandler.prependByteArrayWithControlByte((byte)0, this.sasToken.getBytes(StandardCharsets.UTF_8));
    }

    private byte[] buildNonceFromThirdChallenge(byte[] challengeData) {
        byte[] completeChallengeKey = new byte[this.challengeKey.length + challengeData.length - 1];
        System.arraycopy(this.challengeKey, 0, completeChallengeKey, 0, this.challengeKey.length);
        System.arraycopy(challengeData, 1, completeChallengeKey, this.challengeKey.length, challengeData.length - 1);
        return completeChallengeKey;
    }

    private static byte[] buildSaslInitPayload(String idScope, String registrationId, byte[] endorsementKey) {
        byte[] bytes = AmqpsProvisioningSaslHandler.concatBytesWithNullDelimiter(idScope.getBytes(StandardCharsets.UTF_8), registrationId.getBytes(StandardCharsets.UTF_8), endorsementKey);
        return AmqpsProvisioningSaslHandler.prependByteArrayWithControlByte((byte)0, bytes);
    }

    private static byte[] buildFirstSaslChallengeResponsePayload(byte[] srk) {
        return AmqpsProvisioningSaslHandler.prependByteArrayWithControlByte((byte)0, srk);
    }

    private static byte[] concatBytesWithNullDelimiter(byte[] ... arrays) {
        int totalLength = 0;
        for (byte[] array : arrays) {
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength += arrays.length - 1];
        int currentIndex = 0;
        for (int i = 0; i < arrays.length - 1; ++i) {
            System.arraycopy(arrays[i], 0, result, currentIndex, arrays[i].length);
            result[currentIndex + arrays[i].length] = 0;
            currentIndex += arrays[i].length + 1;
        }
        System.arraycopy(arrays[arrays.length - 1], 0, result, currentIndex, arrays[arrays.length - 1].length);
        return result;
    }

    private static byte[] prependByteArrayWithControlByte(byte controlByte, byte[] bytes) {
        byte[] newByteArray = new byte[bytes.length + 1];
        newByteArray[0] = controlByte;
        System.arraycopy(bytes, 0, newByteArray, 1, bytes.length);
        return newByteArray;
    }

    private static enum ChallengeState {
        WAITING_FOR_MECHANISMS,
        WAITING_TO_BUILD_INIT,
        WAITING_FOR_FIRST_CHALLENGE,
        WAITING_FOR_SECOND_CHALLENGE,
        WAITING_FOR_THIRD_CHALLENGE,
        WAITING_TO_SEND_SAS_TOKEN,
        WAITING_FOR_FINAL_OUTCOME;

    }
}

