/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract;

import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientTransportProtocol;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.SDKUtils;
import java.io.IOException;

public class UrlPathBuilder {
    private final String scope;
    private ProvisioningDeviceClientTransportProtocol provisioningDeviceClientTransportProtocol;
    private StringBuilder url;
    private static final String SLASH = "/";
    private static final String QUESTION = "?";
    private static final String EQUALS = "=";
    private static final String URL_HTTPS = "https://";
    private static final String REGISTRATIONS = "registrations";
    private static final String REGISTER = "register";
    private static final String OPERATIONS = "operations";
    private static final String API_VERSION_STRING = "api-version";

    public UrlPathBuilder(String idScope) throws IllegalArgumentException {
        if (idScope == null || idScope.isEmpty()) {
            throw new IllegalArgumentException("scope id cannot be null or empty");
        }
        this.scope = idScope;
    }

    public UrlPathBuilder(String hostName, String idScope, ProvisioningDeviceClientTransportProtocol protocol) throws IllegalArgumentException {
        if (hostName == null || hostName.isEmpty()) {
            throw new IllegalArgumentException("host name cannot be null or empty");
        }
        if (idScope == null || idScope.isEmpty()) {
            throw new IllegalArgumentException("scope id cannot be null or empty");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        this.scope = idScope;
        this.provisioningDeviceClientTransportProtocol = protocol;
        this.url = new StringBuilder();
        this.url.append(URL_HTTPS);
        this.url.append(hostName);
        this.url.append(SLASH);
        this.url.append(this.scope);
        this.url.append(SLASH);
        this.url.append(REGISTRATIONS);
        this.url.append(SLASH);
    }

    private String generateRegisterUrlHttp(String registrationId) {
        return this.url + registrationId + SLASH + REGISTER + QUESTION + API_VERSION_STRING + EQUALS + SDKUtils.getServiceApiVersion();
    }

    private String generateRequestUrlHttp(String registrationId, String operationsId) {
        return this.url + registrationId + SLASH + OPERATIONS + SLASH + operationsId + QUESTION + API_VERSION_STRING + EQUALS + SDKUtils.getServiceApiVersion();
    }

    public String generateSasTokenUrl(String registrationId) {
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("registration id cannot be null or empty");
        }
        return this.scope + SLASH + REGISTRATIONS + SLASH + registrationId;
    }

    public String generateRegisterUrl(String registrationId) throws IOException {
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("registration id cannot be null or empty");
        }
        switch (this.provisioningDeviceClientTransportProtocol) {
            case HTTPS: {
                return this.generateRegisterUrlHttp(registrationId);
            }
            case MQTT: 
            case MQTT_WS: 
            case AMQPS: 
            case AMQPS_WS: {
                return null;
            }
        }
        throw new IOException("Unspecified protocol");
    }

    public String generateRequestUrl(String registrationId, String operationsId) throws IOException {
        if (registrationId == null || registrationId.isEmpty()) {
            throw new IllegalArgumentException("registration id cannot be null or empty");
        }
        if (operationsId == null || operationsId.length() == 0) {
            throw new IllegalArgumentException("registration id cannot be null or empty");
        }
        switch (this.provisioningDeviceClientTransportProtocol) {
            case HTTPS: {
                return this.generateRequestUrlHttp(registrationId, operationsId);
            }
            case MQTT: 
            case MQTT_WS: 
            case AMQPS: 
            case AMQPS_WS: {
                return null;
            }
        }
        throw new IOException("Unspecified protocol");
    }
}

