/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal.contract;

import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ResponseCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.amqp.ContractAPIAmqp;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.http.ContractAPIHttp;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.mqtt.ContractAPIMqtt;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceConnectionException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.RequestData;

public abstract class ProvisioningDeviceClientContract {
    private int retryValue = DEFAULT_RETRY_AFTER_VALUE;
    protected static final String RETRY_AFTER = "retry-after";
    private static final Integer DEFAULT_RETRY_AFTER_VALUE = 2;
    private static final Integer MAX_PROV_GET_THROTTLE_TIME = 5;

    protected void setRetrieveRetryAfterValue(String protocolRetryValue) {
        if (protocolRetryValue != null && !protocolRetryValue.isEmpty()) {
            this.retryValue = Integer.parseInt(protocolRetryValue);
            if (this.retryValue < DEFAULT_RETRY_AFTER_VALUE || this.retryValue > MAX_PROV_GET_THROTTLE_TIME) {
                this.retryValue = DEFAULT_RETRY_AFTER_VALUE;
            }
        }
    }

    public static ProvisioningDeviceClientContract createProvisioningContract(ProvisioningDeviceClientConfig provisioningDeviceClientConfig) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientConfig == null) {
            throw new ProvisioningDeviceClientException("config cannot be null");
        }
        switch (provisioningDeviceClientConfig.getProtocol()) {
            case MQTT: {
                return new ContractAPIMqtt(provisioningDeviceClientConfig);
            }
            case MQTT_WS: {
                provisioningDeviceClientConfig.setUsingWebSocket(true);
                return new ContractAPIMqtt(provisioningDeviceClientConfig);
            }
            case AMQPS: {
                return new ContractAPIAmqp(provisioningDeviceClientConfig);
            }
            case AMQPS_WS: {
                provisioningDeviceClientConfig.setUsingWebSocket(true);
                return new ContractAPIAmqp(provisioningDeviceClientConfig);
            }
            case HTTPS: {
                return new ContractAPIHttp(provisioningDeviceClientConfig);
            }
        }
        throw new ProvisioningDeviceClientException("Unknown protocol");
    }

    public abstract void open(RequestData var1) throws ProvisioningDeviceConnectionException;

    public abstract void requestNonceForTPM(RequestData var1, ResponseCallback var2, Object var3) throws ProvisioningDeviceClientException;

    public abstract void authenticateWithProvisioningService(RequestData var1, ResponseCallback var2, Object var3) throws ProvisioningDeviceClientException;

    public abstract void getRegistrationStatus(RequestData var1, ResponseCallback var2, Object var3) throws ProvisioningDeviceClientException;

    public abstract void close() throws ProvisioningDeviceConnectionException;

    public abstract String getConnectionId();

    public abstract String getHostName();

    public int getRetryValue() {
        return this.retryValue * 1000;
    }
}

