/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKUtils {
    private static final Logger log = LoggerFactory.getLogger(SDKUtils.class);
    private static final String SERVICE_API_VERSION = "2019-03-31";
    public static final String PROVISIONING_DEVICE_CLIENT_IDENTIFIER = "com.microsoft.azure.sdk.iot.dps.dps-device-client/";
    public static final String PROVISIONING_DEVICE_CLIENT_VERSION = SDKUtils.getPackageVersion();
    private static final String JAVA_RUNTIME = System.getProperty("java.version");
    private static final String OPERATING_SYSTEM = System.getProperty("java.runtime.name").toLowerCase().contains("android") ? "Android" : System.getProperty("os.name");
    private static final String PROCESSOR_ARCHITECTURE = System.getProperty("os.arch");

    public static String getServiceApiVersion() {
        return SERVICE_API_VERSION;
    }

    public static String getUserAgentString() {
        return PROVISIONING_DEVICE_CLIENT_IDENTIFIER + PROVISIONING_DEVICE_CLIENT_VERSION + " (" + JAVA_RUNTIME + "; " + OPERATING_SYSTEM + "; " + PROCESSOR_ARCHITECTURE + ")";
    }

    private static String getPackageVersion() {
        Map<String, String> properties = SDKUtils.getProperties("provisioning-device-client.properties");
        return properties.getOrDefault("version", "UnknownVersion");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getProperties(String propertiesFileName) {
        try (InputStream inputStream = SDKUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException ex) {
            log.warn("Failed to get properties from " + propertiesFileName, (Throwable)ex);
        }
        return Collections.emptyMap();
    }
}

