/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.provisioning.device;

import com.microsoft.azure.sdk.iot.provisioning.device.AdditionalData;
import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientRegistrationCallback;
import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientRegistrationResult;
import com.microsoft.azure.sdk.iot.provisioning.device.ProvisioningDeviceClientTransportProtocol;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.ProvisioningDeviceClientConfig;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.SDKUtils;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.contract.ProvisioningDeviceClientContract;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceClientException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.exceptions.ProvisioningDeviceHubException;
import com.microsoft.azure.sdk.iot.provisioning.device.internal.task.ProvisioningTask;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningDeviceClient {
    private static final Logger log = LoggerFactory.getLogger(ProvisioningDeviceClient.class);
    private static final int MAX_THREADS_TO_RUN = 1;
    private static final int DEFAULT_TIMEOUT_SECONDS = 60;
    private final ProvisioningDeviceClientConfig provisioningDeviceClientConfig;
    private final ProvisioningDeviceClientContract provisioningDeviceClientContract;
    private final ExecutorService executor;

    public static ProvisioningDeviceClient create(String globalEndpoint, String idScope, ProvisioningDeviceClientTransportProtocol protocol, SecurityProvider securityProvider) throws ProvisioningDeviceClientException {
        return new ProvisioningDeviceClient(globalEndpoint, idScope, protocol, securityProvider);
    }

    private ProvisioningDeviceClient(String globalEndpoint, String idScope, ProvisioningDeviceClientTransportProtocol protocol, SecurityProvider securityProvider) throws ProvisioningDeviceClientException {
        if (globalEndpoint == null || globalEndpoint.isEmpty()) {
            throw new IllegalArgumentException("global endpoint cannot be null or empty");
        }
        if (idScope == null || idScope.isEmpty()) {
            throw new IllegalArgumentException("scope id cannot be null or empty");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        if (securityProvider == null) {
            throw new IllegalArgumentException("Security provider cannot be null");
        }
        this.provisioningDeviceClientConfig = new ProvisioningDeviceClientConfig();
        this.provisioningDeviceClientConfig.setProvisioningServiceGlobalEndpoint(globalEndpoint);
        this.provisioningDeviceClientConfig.setIdScope(idScope);
        this.provisioningDeviceClientConfig.setProtocol(protocol);
        this.provisioningDeviceClientConfig.setSecurityProvider(securityProvider);
        this.provisioningDeviceClientContract = ProvisioningDeviceClientContract.createProvisioningContract(this.provisioningDeviceClientConfig);
        this.executor = Executors.newFixedThreadPool(1);
        log.debug("Initialized a ProvisioningDeviceClient instance using SDK version {}", (Object)SDKUtils.PROVISIONING_DEVICE_CLIENT_VERSION);
    }

    public void registerDevice(ProvisioningDeviceClientRegistrationCallback provisioningDeviceClientRegistrationCallback, Object context) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientRegistrationCallback == null) {
            throw new IllegalArgumentException("registration callback cannot be null");
        }
        this.provisioningDeviceClientConfig.setRegistrationCallback(provisioningDeviceClientRegistrationCallback, context);
        log.debug("Starting provisioning thread...");
        ProvisioningTask provisioningTask = new ProvisioningTask(this.provisioningDeviceClientConfig, this.provisioningDeviceClientContract);
        this.executor.submit(provisioningTask);
    }

    public void registerDevice(ProvisioningDeviceClientRegistrationCallback provisioningDeviceClientRegistrationCallback, Object context, AdditionalData additionalData) throws ProvisioningDeviceClientException {
        if (provisioningDeviceClientRegistrationCallback == null) {
            throw new IllegalArgumentException("registration callback cannot be null");
        }
        this.provisioningDeviceClientConfig.setPayload(additionalData.getProvisioningPayload());
        this.provisioningDeviceClientConfig.setRegistrationCallback(provisioningDeviceClientRegistrationCallback, context);
        log.debug("Starting provisioning thread...");
        ProvisioningTask provisioningTask = new ProvisioningTask(this.provisioningDeviceClientConfig, this.provisioningDeviceClientContract);
        this.executor.submit(provisioningTask);
    }

    public ProvisioningDeviceClientRegistrationResult registerDeviceSync() throws ProvisioningDeviceClientException, InterruptedException {
        return this.registerDeviceSync(60);
    }

    public ProvisioningDeviceClientRegistrationResult registerDeviceSync(AdditionalData additionalData) throws ProvisioningDeviceClientException, InterruptedException {
        return this.registerDeviceSync(additionalData, 60);
    }

    public ProvisioningDeviceClientRegistrationResult registerDeviceSync(int timeout) throws ProvisioningDeviceClientException, InterruptedException {
        return this.registerDeviceSync(null, timeout);
    }

    public ProvisioningDeviceClientRegistrationResult registerDeviceSync(AdditionalData additionalData, int timeout) throws ProvisioningDeviceClientException, InterruptedException {
        boolean timedOut;
        CountDownLatch registrationLatch = new CountDownLatch(1);
        AtomicReference registrationResultReference = new AtomicReference();
        AtomicReference registrationExceptionReference = new AtomicReference();
        this.registerDevice((provisioningDeviceClientRegistrationResult, e, context) -> {
            registrationResultReference.set(provisioningDeviceClientRegistrationResult);
            registrationExceptionReference.set(e);
            registrationLatch.countDown();
        }, null);
        boolean bl = timedOut = !registrationLatch.await(timeout, TimeUnit.SECONDS);
        if (timedOut) {
            throw new ProvisioningDeviceClientException("Timed out waiting for registration to complete");
        }
        ProvisioningDeviceClientRegistrationResult registrationResult = (ProvisioningDeviceClientRegistrationResult)registrationResultReference.get();
        Exception registrationException = (Exception)registrationExceptionReference.get();
        if (registrationException != null) {
            if (registrationException instanceof ProvisioningDeviceHubException) {
                throw (ProvisioningDeviceHubException)registrationException;
            }
            throw new ProvisioningDeviceClientException("Failed to register", registrationException);
        }
        return registrationResult;
    }

    public void close() {
        if (this.executor != null && !this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
    }
}

