/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 */

package com.microsoft.azure.toolkit.lib.containerservice.model;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

@Getter
@AllArgsConstructor
@EqualsAndHashCode
public class NetworkPlugin {
    public static final NetworkPlugin AZURE = new NetworkPlugin("azure");
    public static final NetworkPlugin KUBENET = new NetworkPlugin("kubenet");

    private String value;

    public static List<NetworkPlugin> values() {
        return Arrays.asList(AZURE, KUBENET);
    }

    public static NetworkPlugin fromString(String input) {
        return values().stream()
                .filter(logLevel -> StringUtils.equalsIgnoreCase(input, logLevel.getValue()))
                .findFirst().orElse(null);
    }
}
