/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 */

package com.microsoft.azure.toolkit.lib.containerservice.model;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

@Getter
@AllArgsConstructor
@EqualsAndHashCode
public class NetworkMode {
    public static final NetworkMode TRANSPARENT = new NetworkMode("transparent");
    public static final NetworkMode BRIDGE = new NetworkMode("bridge");

    private String value;

    public static List<NetworkMode> values() {
        return Arrays.asList(TRANSPARENT, BRIDGE);
    }

    public static NetworkMode fromString(String input) {
        return values().stream()
                .filter(logLevel -> StringUtils.equalsIgnoreCase(input, logLevel.getValue()))
                .findFirst().orElse(null);
    }
}
