/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.model;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TransportMethod {
    public static final TransportMethod AUTO = new TransportMethod("auto", "Auto");
    public static final TransportMethod HTTP = new TransportMethod("http", "HTTP/1");
    public static final TransportMethod HTTP2 = new TransportMethod("http2", "HTTP/2");
    public static final TransportMethod TCP = new TransportMethod("tcp", "TCP");
    private String value;
    private String displayName;

    public static List<TransportMethod> values() {
        return Arrays.asList(AUTO, HTTP, HTTP2, TCP);
    }

    public static TransportMethod fromString(String input) {
        return TransportMethod.values().stream().filter(logLevel -> StringUtils.equalsIgnoreCase((CharSequence)input, (CharSequence)logLevel.getValue())).findFirst().orElse(null);
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TransportMethod() {
    }

    public TransportMethod(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransportMethod)) {
            return false;
        }
        TransportMethod other = (TransportMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransportMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }
}

