/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.resourcemanager.appcontainers.implementation.ContainerAppImpl;
import com.azure.resourcemanager.appcontainers.models.ActiveRevisionsMode;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.Container;
import com.azure.resourcemanager.appcontainers.models.ContainerApp;
import com.azure.resourcemanager.appcontainers.models.ContainerApps;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVar;
import com.azure.resourcemanager.appcontainers.models.Ingress;
import com.azure.resourcemanager.appcontainers.models.RegistryCredentials;
import com.azure.resourcemanager.appcontainers.models.Secret;
import com.azure.resourcemanager.appcontainers.models.Template;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppModule;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import com.microsoft.azure.toolkit.lib.containerapps.model.IngressConfig;
import com.microsoft.azure.toolkit.lib.containerapps.model.RevisionMode;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerAppDraft
extends ContainerApp
implements AzResource.Draft<ContainerApp, com.azure.resourcemanager.appcontainers.models.ContainerApp> {
    @Nullable
    private final ContainerApp origin;
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected ContainerAppDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ContainerAppModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    protected ContainerAppDraft(@Nonnull ContainerApp origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="azure/containerapps.create_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appcontainers.models.ContainerApp createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerApps client = Objects.requireNonNull(((ContainerAppModule)this.getModule()).getClient());
            ContainerAppsEnvironment containerAppsEnvironment = Objects.requireNonNull(this.ensureConfig().getEnvironment(), "Environment is required to create Container app.");
            if (containerAppsEnvironment.isDraftForCreating()) {
                ((ContainerAppsEnvironmentDraft)containerAppsEnvironment).commit();
            }
            ImageConfig imageConfig = Objects.requireNonNull(this.ensureConfig().getImageConfig(), "Image is required to create Container app.");
            Configuration configuration = new Configuration();
            Optional.ofNullable(this.ensureConfig().getRevisionMode()).ifPresent(mode -> configuration.withActiveRevisionsMode(ActiveRevisionsMode.fromString((String)this.ensureConfig().getRevisionMode().getValue())));
            configuration.withSecrets(Optional.ofNullable(ContainerAppDraft.getSecret(imageConfig)).map(Collections::singletonList).orElse(Collections.emptyList()));
            configuration.withRegistries(Optional.ofNullable(ContainerAppDraft.getRegistryCredential(imageConfig)).map(Collections::singletonList).orElse(Collections.emptyList()));
            configuration.withIngress((Ingress)Optional.ofNullable(this.ensureConfig().getIngressConfig()).map(IngressConfig::toIngress).orElse(null));
            Template template = new Template().withContainers(ContainerAppDraft.getContainers(imageConfig));
            AzureMessager.getMessager().info(AzureString.format((String)"Start creating Azure Container App({0})...", (Object[])new Object[]{this.getName()}));
            com.azure.resourcemanager.appcontainers.models.ContainerApp result = client.define(this.ensureConfig().getName()).withRegion(com.azure.core.management.Region.fromName((String)this.ensureConfig().getRegion().getName())).withExistingResourceGroup(Objects.requireNonNull(this.ensureConfig().getResourceGroup(), "Resource Group is required to create Container app.").getResourceGroupName()).withManagedEnvironmentId(containerAppsEnvironment.getId()).withConfiguration(configuration).withTemplate(template).create();
            Action updateImage = AzureActionManager.getInstance().getAction(ContainerApp.UPDATE_IMAGE).bind((Object)this);
            Action browse = AzureActionManager.getInstance().getAction(ContainerApp.BROWSE).bind((Object)this);
            AzureMessager.getMessager().success(AzureString.format((String)"Azure Container App({0}) is successfully created.", (Object[])new Object[]{this.getName()}), new Object[]{browse, updateImage});
            com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return containerApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nullable
    public IngressConfig getIngressConfig() {
        return Optional.ofNullable(this.config).map(Config::getIngressConfig).orElse(super.getIngressConfig());
    }

    @Override
    @Nullable
    public RevisionMode getRevisionMode() {
        return Optional.ofNullable(this.config).map(Config::getRevisionMode).orElse(super.getRevisionMode());
    }

    @Override
    @Nullable
    public ContainerAppsEnvironment getManagedEnvironment() {
        return Optional.ofNullable(this.config).map(Config::getEnvironment).orElseGet(() -> super.getManagedEnvironment());
    }

    @Override
    @Nullable
    public String getManagedEnvironmentId() {
        return Optional.ofNullable(this.config).map(Config::getEnvironment).map(AbstractAzResource::getId).orElseGet(() -> super.getManagedEnvironmentId());
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion());
    }

    @Override
    public boolean isIngressEnabled() {
        return Optional.ofNullable(this.config).map(Config::getIngressConfig).map(IngressConfig::isEnableIngress).orElseGet(() -> super.isIngressEnabled());
    }

    @Nonnull
    @AzureOperation(name="azure/containerapps.update_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appcontainers.models.ContainerApp updateResourceInAzure(@Nonnull com.azure.resourcemanager.appcontainers.models.ContainerApp origin) {
        com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)containerApp);
        try {
            com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp2;
            boolean isModified;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            IAzureMessager messager = AzureMessager.getMessager();
            Config config = this.ensureConfig();
            ImageConfig imageConfig = config.getImageConfig();
            IngressConfig ingressConfig = config.getIngressConfig();
            RevisionMode revisionMode = config.getRevisionMode();
            boolean isImageModified = Objects.nonNull(imageConfig);
            boolean isIngressConfigModified = Objects.nonNull(ingressConfig) && !Objects.equals(ingressConfig, super.getIngressConfig());
            boolean isRevisionModeModified = !Objects.equals(revisionMode, super.getRevisionMode());
            boolean bl = isModified = isImageModified || isIngressConfigModified || isRevisionModeModified;
            if (!isModified) {
                containerApp2 = origin;
            } else {
                ContainerAppImpl update = (ContainerAppImpl)(isImageModified ? this.updateImage(origin) : origin.update());
                Configuration configuration = update.configuration();
                if (!isImageModified) {
                    List secrets = origin.listSecrets().value().stream().map(s -> new Secret().withName(s.name()).withValue(s.value())).collect(Collectors.toList());
                    List registries = Optional.ofNullable(origin.configuration().registries()).map(ArrayList::new).orElseGet(ArrayList::new);
                    configuration.withRegistries(registries).withSecrets(secrets);
                }
                if (isIngressConfigModified) {
                    configuration.withIngress(ingressConfig.toIngress());
                }
                if (isRevisionModeModified) {
                    configuration.withActiveRevisionsMode(revisionMode.toActiveRevisionMode());
                }
                update.withConfiguration(configuration);
                messager.info(AzureString.format((String)"Start updating Container App({0})...", (Object[])new Object[]{this.getName()}));
                com.azure.resourcemanager.appcontainers.models.ContainerApp result = update.apply();
                Action browse = AzureActionManager.getInstance().getAction(ContainerApp.BROWSE).bind((Object)this);
                messager.success(AzureString.format((String)"Container App({0}) is successfully updated.", (Object[])new Object[]{this.getName()}), new Object[]{browse});
                if (isImageModified) {
                    AzureTaskManager.getInstance().runOnPooledThread(() -> this.getRevisionModule().refresh());
                }
                containerApp2 = result;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return containerApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private ContainerApp.Update updateImage(@Nonnull com.azure.resourcemanager.appcontainers.models.ContainerApp origin) {
        ImageConfig config = Objects.requireNonNull(this.getConfig().getImageConfig(), "image config is null.");
        ContainerApp.Update update = origin.update();
        ContainerRegistry registry = config.getContainerRegistry();
        List secrets = origin.listSecrets().value().stream().map(s -> new Secret().withName(s.name()).withValue(s.value())).collect(Collectors.toList());
        List registries = Optional.ofNullable(origin.configuration().registries()).map(ArrayList::new).orElseGet(ArrayList::new);
        if (Objects.nonNull(registry)) {
            Optional.ofNullable(ContainerAppDraft.getSecret(config)).ifPresent(secret -> {
                secrets.removeIf(r -> r.name().equalsIgnoreCase(secret.name()));
                secrets.add(secret);
            });
            Optional.ofNullable(ContainerAppDraft.getRegistryCredential(config)).ifPresent(credential -> {
                registries.removeIf(r -> r.server().equalsIgnoreCase(credential.server()));
                registries.add(credential);
            });
        }
        update.withConfiguration(origin.configuration().withRegistries(registries).withSecrets(secrets));
        return update.withTemplate(origin.template().withContainers(ContainerAppDraft.getContainers(config)));
    }

    @Nullable
    private static Secret getSecret(ImageConfig config) {
        ContainerRegistry registry = config.getContainerRegistry();
        if (Objects.nonNull(registry)) {
            String password = Optional.ofNullable(registry.getPrimaryCredential()).orElseGet(() -> ((ContainerRegistry)registry).getSecondaryCredential());
            String passwordKey = Objects.equals(password, registry.getPrimaryCredential()) ? "password" : "password2";
            String passwordName = String.format("%s-%s", registry.getName().toLowerCase(), passwordKey);
            return new Secret().withName(passwordName).withValue(password);
        }
        return null;
    }

    @Nullable
    private static RegistryCredentials getRegistryCredential(ImageConfig config) {
        ContainerRegistry registry = config.getContainerRegistry();
        if (Objects.nonNull(registry)) {
            String username = registry.getUserName();
            String password = Optional.ofNullable(registry.getPrimaryCredential()).orElseGet(() -> ((ContainerRegistry)registry).getSecondaryCredential());
            String passwordKey = Objects.equals(password, registry.getPrimaryCredential()) ? "password" : "password2";
            String passwordName = String.format("%s-%s", registry.getName().toLowerCase(), passwordKey);
            return new RegistryCredentials().withServer(registry.getLoginServerUrl()).withUsername(username).withPasswordSecretRef(passwordName);
        }
        return null;
    }

    private static List<Container> getContainers(@Nonnull ImageConfig config) {
        String imageId = config.getFullImageName();
        String containerName = ContainerAppDraft.getContainerNameForImage(imageId);
        return Collections.singletonList(new Container().withName(containerName).withImage(imageId).withEnv(config.getEnvironmentVariables()));
    }

    private static String getContainerNameForImage(String containerImageName) {
        return containerImageName.substring(containerImageName.lastIndexOf(47) + 1).replaceAll("[^0-9a-zA-Z-]", "-");
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public boolean isModified() {
        return this.config == null || Objects.equals(this.config, new Config());
    }

    @Nullable
    public ContainerApp getOrigin() {
        return this.origin;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    static {
        ContainerAppDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerAppDraft.java", ContainerAppDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft", "", "", "", "com.azure.resourcemanager.appcontainers.models.ContainerApp"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft", "com.azure.resourcemanager.appcontainers.models.ContainerApp", "origin", "", "com.azure.resourcemanager.appcontainers.models.ContainerApp"), 142);
    }

    public static class ImageConfig {
        @Nonnull
        private final String fullImageName;
        @Nullable
        private ContainerRegistry containerRegistry;
        @Nonnull
        private List<EnvironmentVar> environmentVariables = new ArrayList<EnvironmentVar>();

        public ImageConfig(@Nonnull String fullImageName) {
            this.fullImageName = fullImageName;
        }

        public String getTag() {
            return Optional.of(this.fullImageName.substring(this.fullImageName.lastIndexOf(58) + 1)).filter(StringUtils::isNotBlank).orElse("latest");
        }

        public void setContainerRegistry(@Nullable ContainerRegistry containerRegistry) {
            this.containerRegistry = containerRegistry;
        }

        public void setEnvironmentVariables(@Nonnull List<EnvironmentVar> environmentVariables) {
            if (environmentVariables == null) {
                throw new NullPointerException("environmentVariables is marked non-null but is null");
            }
            this.environmentVariables = environmentVariables;
        }

        @Nonnull
        public String getFullImageName() {
            return this.fullImageName;
        }

        @Nullable
        public ContainerRegistry getContainerRegistry() {
            return this.containerRegistry;
        }

        @Nonnull
        public List<EnvironmentVar> getEnvironmentVariables() {
            return this.environmentVariables;
        }
    }

    public static class Config {
        private String name;
        private Subscription subscription;
        private ResourceGroup resourceGroup;
        private Region region;
        @Nullable
        private ContainerAppsEnvironment environment;
        private RevisionMode revisionMode = RevisionMode.SINGLE;
        @Nullable
        private ImageConfig imageConfig;
        @Nullable
        private IngressConfig ingressConfig;

        public String getName() {
            return this.name;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public ResourceGroup getResourceGroup() {
            return this.resourceGroup;
        }

        public Region getRegion() {
            return this.region;
        }

        @Nullable
        public ContainerAppsEnvironment getEnvironment() {
            return this.environment;
        }

        public RevisionMode getRevisionMode() {
            return this.revisionMode;
        }

        @Nullable
        public ImageConfig getImageConfig() {
            return this.imageConfig;
        }

        @Nullable
        public IngressConfig getIngressConfig() {
            return this.ingressConfig;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        public void setResourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public void setEnvironment(@Nullable ContainerAppsEnvironment environment) {
            this.environment = environment;
        }

        public void setRevisionMode(RevisionMode revisionMode) {
            this.revisionMode = revisionMode;
        }

        public void setImageConfig(@Nullable ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
        }

        public void setIngressConfig(@Nullable IngressConfig ingressConfig) {
            this.ingressConfig = ingressConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Subscription this$subscription = this.getSubscription();
            Subscription other$subscription = other.getSubscription();
            if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
                return false;
            }
            ResourceGroup this$resourceGroup = this.getResourceGroup();
            ResourceGroup other$resourceGroup = other.getResourceGroup();
            if (this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            ContainerAppsEnvironment this$environment = this.getEnvironment();
            ContainerAppsEnvironment other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !((Object)((Object)this$environment)).equals((Object)other$environment)) {
                return false;
            }
            RevisionMode this$revisionMode = this.getRevisionMode();
            RevisionMode other$revisionMode = other.getRevisionMode();
            if (this$revisionMode == null ? other$revisionMode != null : !((Object)this$revisionMode).equals(other$revisionMode)) {
                return false;
            }
            ImageConfig this$imageConfig = this.getImageConfig();
            ImageConfig other$imageConfig = other.getImageConfig();
            if (this$imageConfig == null ? other$imageConfig != null : !this$imageConfig.equals(other$imageConfig)) {
                return false;
            }
            IngressConfig this$ingressConfig = this.getIngressConfig();
            IngressConfig other$ingressConfig = other.getIngressConfig();
            return !(this$ingressConfig == null ? other$ingressConfig != null : !((Object)this$ingressConfig).equals(other$ingressConfig));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Subscription $subscription = this.getSubscription();
            result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
            ResourceGroup $resourceGroup = this.getResourceGroup();
            result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            ContainerAppsEnvironment $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : ((Object)((Object)$environment)).hashCode());
            RevisionMode $revisionMode = this.getRevisionMode();
            result = result * 59 + ($revisionMode == null ? 43 : ((Object)$revisionMode).hashCode());
            ImageConfig $imageConfig = this.getImageConfig();
            result = result * 59 + ($imageConfig == null ? 43 : $imageConfig.hashCode());
            IngressConfig $ingressConfig = this.getIngressConfig();
            result = result * 59 + ($ingressConfig == null ? 43 : ((Object)$ingressConfig).hashCode());
            return result;
        }

        public String toString() {
            return "ContainerAppDraft.Config(name=" + this.getName() + ", subscription=" + this.getSubscription() + ", resourceGroup=" + this.getResourceGroup() + ", region=" + this.getRegion() + ", environment=" + (Object)((Object)this.getEnvironment()) + ", revisionMode=" + this.getRevisionMode() + ", imageConfig=" + this.getImageConfig() + ", ingressConfig=" + this.getIngressConfig() + ")";
        }
    }
}

