/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zafarkhaja.semver.Version;
import com.google.gson.JsonObject;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.auth.exception.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.model.AzureCliSubscription;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.utils.CommandUtils;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class AzureCliUtils {
    private static final String MIN_VERSION = "2.11.0";

    public static void ensureMinimumCliVersion() {
        try {
            JsonObject result = (JsonObject)JsonUtils.getGson().fromJson(AzureCliUtils.executeAzureCli("az version --output json"), JsonObject.class);
            String cliVersion = result.get("azure-cli").getAsString();
            if (Version.valueOf((String)cliVersion).lessThan(Version.valueOf((String)MIN_VERSION))) {
                throw new AzureToolkitAuthenticationException(String.format("your Azure Cli version '%s' is too old, you need to upgrade your CLI with 'az upgrade'.", cliVersion));
            }
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new AzureToolkitAuthenticationException(String.format("Azure Cli is not ready, please make sure your Azure Cli is installed and signed-in, the detailed error is : %s", ex.getMessage()));
        }
    }

    @Nonnull
    public static List<AzureCliSubscription> listSubscriptions() {
        String jsonString = AzureCliUtils.executeAzureCli("az account list --output json");
        ObjectMapper mapper = new ObjectMapper();
        try {
            AzureCliSubscription[] subscriptions = (AzureCliSubscription[])mapper.readValue(jsonString, AzureCliSubscription[].class);
            return Arrays.stream(subscriptions).filter(s -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{s.getId(), s.getName()}) && s.getState().equalsIgnoreCase("Enabled")).filter(Utils.distinctByKey(t -> StringUtils.lowerCase((String)t.getId()))).collect(Collectors.toList());
        }
        catch (JsonProcessingException e) {
            throw new AzureToolkitRuntimeException("failed to load subscriptions from Azure CLI");
        }
    }

    @Nonnull
    public static String executeAzureCli(@Nonnull String command) {
        try {
            AzureConfiguration config = Azure.az().config();
            HashMap<String, String> env = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)config.getProxySource())) {
                String proxyAuthPrefix = "";
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getProxyUsername(), config.getProxyPassword()})) {
                    proxyAuthPrefix = config.getProxyUsername() + ":" + config.getProxyPassword() + "@";
                }
                String proxyStr = String.format("http://%s%s:%s", proxyAuthPrefix, config.getHttpProxyHost(), config.getHttpProxyPort());
                env.put("HTTPS_PROXY", proxyStr);
                env.put("HTTP_PROXY", proxyStr);
            }
            return CommandUtils.exec((String)command, env);
        }
        catch (IOException e) {
            throw new AzureToolkitAuthenticationException(String.format("execute Azure Cli command '%s' failed due to error: %s.", command, e.getMessage()));
        }
    }
}

