/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.queue.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.util.Map;

/**
 * An Azure Storage Queue.
 */
@JacksonXmlRootElement(localName = "Queue")
public final class QueueItem {
    /**
     * The name of the Queue.
     */
    @JsonProperty(value = "Name", required = true)
    private String name;

    /**
     * The metadata property.
     */
    @JsonProperty(value = "Metadata")
    private Map<String, String> metadata;

    /**
     * Get the name value.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name
     *         the name value to set.
     *
     * @return the QueueItem object itself.
     */
    public QueueItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the metadata value.
     *
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata value.
     *
     * @param metadata
     *         the metadata value to set.
     *
     * @return the QueueItem object itself.
     */
    public QueueItem withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}
