/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.queue.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.annotations.HeaderCollection;

import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Defines headers for GetProperties operation.
 */
@JacksonXmlRootElement(localName = "Queue-GetProperties-Headers")
public final class QueueGetPropertiesHeaders {
    /**
     * The metadata property.
     */
    @HeaderCollection("x-ms-meta-")
    private Map<String, String> metadata;

    /**
     * The approximate number of messages in the queue. This number is not
     * lower than the actual number of messages in the queue, but could be
     * higher.
     */
    @JsonProperty(value = "x-ms-approximate-messages-count")
    private Integer approximateMessagesCount;

    /**
     * This header uniquely identifies the request that was made and can be
     * used for troubleshooting the request.
     */
    @JsonProperty(value = "x-ms-request-id")
    private String requestId;

    /**
     * Indicates the version of the Queue service used to execute the request.
     * This header is returned for requests made against version 2009-09-19 and
     * above.
     */
    @JsonProperty(value = "x-ms-version")
    private String version;

    /**
     * UTC date/time value generated by the service that indicates the time at
     * which the response was initiated.
     */
    @JsonProperty(value = "Date")
    private DateTimeRfc1123 date;

    /**
     * Get the metadata value.
     *
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata value.
     *
     * @param metadata
     *         the metadata value to set.
     *
     * @return the QueueGetPropertiesHeaders object itself.
     */
    public QueueGetPropertiesHeaders withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the approximateMessagesCount value.
     *
     * @return the approximateMessagesCount value.
     */
    public Integer approximateMessagesCount() {
        return this.approximateMessagesCount;
    }

    /**
     * Set the approximateMessagesCount value.
     *
     * @param approximateMessagesCount
     *         the approximateMessagesCount value to
     *         set.
     *
     * @return the QueueGetPropertiesHeaders object itself.
     */
    public QueueGetPropertiesHeaders withApproximateMessagesCount(Integer approximateMessagesCount) {
        this.approximateMessagesCount = approximateMessagesCount;
        return this;
    }

    /**
     * Get the requestId value.
     *
     * @return the requestId value.
     */
    public String requestId() {
        return this.requestId;
    }

    /**
     * Set the requestId value.
     *
     * @param requestId
     *         the requestId value to set.
     *
     * @return the QueueGetPropertiesHeaders object itself.
     */
    public QueueGetPropertiesHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    /**
     * Get the version value.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version value.
     *
     * @param version
     *         the version value to set.
     *
     * @return the QueueGetPropertiesHeaders object itself.
     */
    public QueueGetPropertiesHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the date value.
     *
     * @return the date value.
     */
    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    /**
     * Set the date value.
     *
     * @param date
     *         the date value to set.
     *
     * @return the QueueGetPropertiesHeaders object itself.
     */
    public QueueGetPropertiesHeaders withDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }
}
