/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.queue.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.rest.v2.DateTimeRfc1123;

import java.time.OffsetDateTime;

/**
 * The object returned in the QueueMessageList array when calling Peek Messages
 * on a Queue.
 */
@JacksonXmlRootElement(localName = "QueueMessage")
public final class PeekedMessageItem {
    /**
     * The Id of the Message.
     */
    @JsonProperty(value = "MessageId", required = true)
    private String messageId;

    /**
     * The time the Message was inserted into the Queue.
     */
    @JsonProperty(value = "InsertionTime", required = true)
    private DateTimeRfc1123 insertionTime;

    /**
     * The time that the Message will expire and be automatically deleted.
     */
    @JsonProperty(value = "ExpirationTime", required = true)
    private DateTimeRfc1123 expirationTime;

    /**
     * The number of times the message has been dequeued.
     */
    @JsonProperty(value = "DequeueCount", required = true)
    private long dequeueCount;

    /**
     * The content of the Message.
     */
    @JsonProperty(value = "MessageText", required = true)
    private String messageText;

    /**
     * Get the messageId value.
     *
     * @return the messageId value.
     */
    public String messageId() {
        return this.messageId;
    }

    /**
     * Set the messageId value.
     *
     * @param messageId
     *         the messageId value to set.
     *
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem withMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the insertionTime value.
     *
     * @return the insertionTime value.
     */
    public OffsetDateTime insertionTime() {
        if (this.insertionTime == null) {
            return null;
        }
        return this.insertionTime.dateTime();
    }

    /**
     * Set the insertionTime value.
     *
     * @param insertionTime
     *         the insertionTime value to set.
     *
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem withInsertionTime(OffsetDateTime insertionTime) {
        if (insertionTime == null) {
            this.insertionTime = null;
        } else {
            this.insertionTime = new DateTimeRfc1123(insertionTime);
        }
        return this;
    }

    /**
     * Get the expirationTime value.
     *
     * @return the expirationTime value.
     */
    public OffsetDateTime expirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return this.expirationTime.dateTime();
    }

    /**
     * Set the expirationTime value.
     *
     * @param expirationTime
     *         the expirationTime value to set.
     *
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem withExpirationTime(OffsetDateTime expirationTime) {
        if (expirationTime == null) {
            this.expirationTime = null;
        } else {
            this.expirationTime = new DateTimeRfc1123(expirationTime);
        }
        return this;
    }

    /**
     * Get the dequeueCount value.
     *
     * @return the dequeueCount value.
     */
    public long dequeueCount() {
        return this.dequeueCount;
    }

    /**
     * Set the dequeueCount value.
     *
     * @param dequeueCount
     *         the dequeueCount value to set.
     *
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem withDequeueCount(long dequeueCount) {
        this.dequeueCount = dequeueCount;
        return this;
    }

    /**
     * Get the messageText value.
     *
     * @return the messageText value.
     */
    public String messageText() {
        return this.messageText;
    }

    /**
     * Set the messageText value.
     *
     * @param messageText
     *         the messageText value to set.
     *
     * @return the PeekedMessageItem object itself.
     */
    public PeekedMessageItem withMessageText(String messageText) {
        this.messageText = messageText;
        return this;
    }
}
