/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage.queue.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.util.ArrayList;
import java.util.List;

/**
 * The object returned when calling List Queues on a Queue Service.
 */
@JacksonXmlRootElement(localName = "EnumerationResults")
public final class ListQueuesResponse {
    /**
     * The serviceEndpoint property.
     */
    @JacksonXmlProperty(localName = "ServiceEndpoint", isAttribute = true)
    private String serviceEndpoint;

    /**
     * The prefix property.
     */
    @JsonProperty(value = "Prefix", required = true)
    private String prefix;

    /**
     * The marker property.
     */
    @JsonProperty(value = "Marker")
    private String marker;

    /**
     * The maxResults property.
     */
    @JsonProperty(value = "MaxResults", required = true)
    private int maxResults;

    private static final class QueuesWrapper {
        @JacksonXmlProperty(localName = "Queue")
        private final List<QueueItem> items;

        @JsonCreator
        private QueuesWrapper(@JacksonXmlProperty(localName = "Queue") List<QueueItem> items) {
            this.items = items;
        }
    }

    /**
     * The queueItems property.
     */
    @JsonProperty(value = "Queues")
    private QueuesWrapper queueItems;

    /**
     * The nextMarker property.
     */
    @JsonProperty(value = "NextMarker", required = true)
    private String nextMarker;

    /**
     * Get the serviceEndpoint value.
     *
     * @return the serviceEndpoint value.
     */
    public String serviceEndpoint() {
        return this.serviceEndpoint;
    }

    /**
     * Set the serviceEndpoint value.
     *
     * @param serviceEndpoint
     *         the serviceEndpoint value to set.
     *
     * @return the ListQueuesResponse object itself.
     */
    public ListQueuesResponse withServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    /**
     * Get the prefix value.
     *
     * @return the prefix value.
     */
    public String prefix() {
        return this.prefix;
    }

    /**
     * Set the prefix value.
     *
     * @param prefix
     *         the prefix value to set.
     *
     * @return the ListQueuesResponse object itself.
     */
    public ListQueuesResponse withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * Get the marker value.
     *
     * @return the marker value.
     */
    public String marker() {
        return this.marker;
    }

    /**
     * Set the marker value.
     *
     * @param marker
     *         the marker value to set.
     *
     * @return the ListQueuesResponse object itself.
     */
    public ListQueuesResponse withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    /**
     * Get the maxResults value.
     *
     * @return the maxResults value.
     */
    public int maxResults() {
        return this.maxResults;
    }

    /**
     * Set the maxResults value.
     *
     * @param maxResults
     *         the maxResults value to set.
     *
     * @return the ListQueuesResponse object itself.
     */
    public ListQueuesResponse withMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    /**
     * Get the queueItems value.
     *
     * @return the queueItems value.
     */
    public List<QueueItem> queueItems() {
        if (this.queueItems == null) {
            this.queueItems = new QueuesWrapper(new ArrayList<QueueItem>());
        }
        return this.queueItems.items;
    }

    /**
     * Set the queueItems value.
     *
     * @param queueItems
     *         the queueItems value to set.
     *
     * @return the ListQueuesResponse object itself.
     */
    public ListQueuesResponse withQueueItems(List<QueueItem> queueItems) {
        this.queueItems = new QueuesWrapper(queueItems);
        return this;
    }

    /**
     * Get the nextMarker value.
     *
     * @return the nextMarker value.
     */
    public String nextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker value.
     *
     * @param nextMarker
     *         the nextMarker value to set.
     *
     * @return the ListQueuesResponse object itself.
     */
    public ListQueuesResponse withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }
}
