/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage;

import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.annotations.NonNull;

/**
 * Initializes a new instance of the GeneratedStorageClient type.
 */
public final class GeneratedStorageClient extends ServiceClient {
    /**
     * The URL of the service account, queue or message that is the targe of the desired operation.
     */
    private String url;

    /**
     * Gets The URL of the service account, queue or message that is the targe of the desired operation.
     *
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Sets The URL of the service account, queue or message that is the targe of the desired operation.
     *
     * @param url
     *         the url value.
     *
     * @return the service client itself.
     */
    public GeneratedStorageClient withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Specifies the version of the operation to use for this request.
     */
    private String version;

    /**
     * Gets Specifies the version of the operation to use for this request.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Sets Specifies the version of the operation to use for this request.
     *
     * @param version
     *         the version value.
     *
     * @return the service client itself.
     */
    public GeneratedStorageClient withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * The GeneratedServices object to access its operations.
     */
    private GeneratedServices generatedServices;

    /**
     * Gets the GeneratedServices object to access its operations.
     *
     * @return the GeneratedServices object.
     */
    public GeneratedServices generatedServices() {
        return this.generatedServices;
    }

    /**
     * The GeneratedQueues object to access its operations.
     */
    private GeneratedQueues generatedQueues;

    /**
     * Gets the GeneratedQueues object to access its operations.
     *
     * @return the GeneratedQueues object.
     */
    public GeneratedQueues generatedQueues() {
        return this.generatedQueues;
    }

    /**
     * The GeneratedMessages object to access its operations.
     */
    private GeneratedMessages generatedMessages;

    /**
     * Gets the GeneratedMessages object to access its operations.
     *
     * @return the GeneratedMessages object.
     */
    public GeneratedMessages generatedMessages() {
        return this.generatedMessages;
    }

    /**
     * The GeneratedMessageIDs object to access its operations.
     */
    private GeneratedMessageIDs generatedMessageIDs;

    /**
     * Gets the GeneratedMessageIDs object to access its operations.
     *
     * @return the GeneratedMessageIDs object.
     */
    public GeneratedMessageIDs generatedMessageIDs() {
        return this.generatedMessageIDs;
    }

    /**
     * Initializes an instance of GeneratedStorageClient client.
     */
    public GeneratedStorageClient() {
        this(RestProxy.createDefaultPipeline());
    }

    /**
     * Initializes an instance of GeneratedStorageClient client.
     *
     * @param httpPipeline
     *         The HTTP pipeline to send requests through.
     */
    public GeneratedStorageClient(@NonNull HttpPipeline httpPipeline) {
        super(httpPipeline);
        this.generatedServices = new GeneratedServices(this);
        this.generatedQueues = new GeneratedQueues(this);
        this.generatedMessages = new GeneratedMessages(this);
        this.generatedMessageIDs = new GeneratedMessageIDs(this);
    }
}
