/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage;

import com.microsoft.azure.storage.queue.models.ListQueuesIncludeType;
import com.microsoft.azure.storage.queue.models.ListQueuesResponse;
import com.microsoft.azure.storage.queue.models.ServiceGetPropertiesResponse;
import com.microsoft.azure.storage.queue.models.ServiceGetStatisticsResponse;
import com.microsoft.azure.storage.queue.models.ServiceListQueuesSegmentResponse;
import com.microsoft.azure.storage.queue.models.ServiceSetPropertiesResponse;
import com.microsoft.azure.storage.queue.models.StorageErrorException;
import com.microsoft.azure.storage.queue.models.StorageServiceProperties;
import com.microsoft.azure.storage.queue.models.StorageServiceStats;
import com.microsoft.rest.v2.CollectionFormat;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;

import java.util.ArrayList;
import java.util.List;

/**
 * An instance of this class provides access to all the operations defined in
 * GeneratedServices.
 */
public final class GeneratedServices {
    /**
     * The proxy service used to perform REST calls.
     */
    private ServicesService service;

    /**
     * The service client containing this operation class.
     */
    private GeneratedStorageClient client;

    /**
     * Initializes an instance of GeneratedServices.
     *
     * @param client
     *         the instance of the service client containing this operation class.
     */
    public GeneratedServices(GeneratedStorageClient client) {
        this.service = RestProxy.create(ServicesService.class, client);
        this.client = client;
    }

    /**
     * The interface defining all the services for GeneratedServices to be used
     * by the proxy service to perform REST calls.
     */
    @Host("{url}")
    private interface ServicesService {
        @PUT("")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<ServiceSetPropertiesResponse> setProperties(Context context, @HostParam("url") String url, @BodyParam("application/xml; charset=utf-8") StorageServiceProperties storageServiceProperties, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("restype") String restype, @QueryParam("comp") String comp);

        @GET("")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<ServiceGetPropertiesResponse> getProperties(Context context, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("restype") String restype, @QueryParam("comp") String comp);

        @GET("")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<ServiceGetStatisticsResponse> getStatistics(Context context, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("restype") String restype, @QueryParam("comp") String comp);

        @GET("")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<ServiceListQueuesSegmentResponse> listQueuesSegment(Context context, @HostParam("url") String url, @QueryParam("prefix") String prefix, @QueryParam("marker") String marker, @QueryParam("maxresults") Integer maxresults, @QueryParam("include") String include, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp);
    }

    /**
     * Sets properties for a storage account's Queue service endpoint, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param storageServiceProperties
     *         The StorageService properties.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void setProperties(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        setPropertiesAsync(context, storageServiceProperties, timeout, requestId).blockingAwait();
    }

    /**
     * Sets properties for a storage account's Queue service endpoint, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param storageServiceProperties
     *         The StorageService properties.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> setPropertiesAsync(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(setPropertiesAsync(context, storageServiceProperties, timeout, requestId), serviceCallback);
    }

    /**
     * Sets properties for a storage account's Queue service endpoint, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param storageServiceProperties
     *         The StorageService properties.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<ServiceSetPropertiesResponse> setPropertiesWithRestResponseAsync(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (storageServiceProperties == null) {
            throw new IllegalArgumentException("Parameter storageServiceProperties is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(storageServiceProperties);
        final String restype = "service";
        final String comp = "properties";
        return service.setProperties(context, this.client.url(), storageServiceProperties, timeout, this.client.version(), requestId, restype, comp);
    }

    /**
     * Sets properties for a storage account's Queue service endpoint, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param storageServiceProperties
     *         The StorageService properties.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable setPropertiesAsync(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        return setPropertiesWithRestResponseAsync(context, storageServiceProperties, timeout, requestId)
                .toCompletable();
    }

    /**
     * gets the properties of a storage account's Queue service, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return the StorageServiceProperties object if successful.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public StorageServiceProperties getProperties(Context context, Integer timeout, String requestId) {
        return getPropertiesAsync(context, timeout, requestId).blockingGet();
    }

    /**
     * gets the properties of a storage account's Queue service, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<StorageServiceProperties> getPropertiesAsync(Context context, Integer timeout, String requestId, ServiceCallback<StorageServiceProperties> serviceCallback) {
        return ServiceFuture.fromBody(getPropertiesAsync(context, timeout, requestId), serviceCallback);
    }

    /**
     * gets the properties of a storage account's Queue service, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<ServiceGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        final String restype = "service";
        final String comp = "properties";
        return service.getProperties(context, this.client.url(), timeout, this.client.version(), requestId, restype, comp);
    }

    /**
     * gets the properties of a storage account's Queue service, including properties for Storage Analytics and CORS (Cross-Origin Resource Sharing) rules.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Maybe<StorageServiceProperties> getPropertiesAsync(Context context, Integer timeout, String requestId) {
        return getPropertiesWithRestResponseAsync(context, timeout, requestId)
                .flatMapMaybe((ServiceGetPropertiesResponse res) -> res.body() == null ? Maybe.empty() : Maybe.just(res.body()));
    }

    /**
     * Retrieves statistics related to replication for the Queue service. It is only available on the secondary location endpoint when read-access geo-redundant replication is enabled for the storage account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return the StorageServiceStats object if successful.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public StorageServiceStats getStatistics(Context context, Integer timeout, String requestId) {
        return getStatisticsAsync(context, timeout, requestId).blockingGet();
    }

    /**
     * Retrieves statistics related to replication for the Queue service. It is only available on the secondary location endpoint when read-access geo-redundant replication is enabled for the storage account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<StorageServiceStats> getStatisticsAsync(Context context, Integer timeout, String requestId, ServiceCallback<StorageServiceStats> serviceCallback) {
        return ServiceFuture.fromBody(getStatisticsAsync(context, timeout, requestId), serviceCallback);
    }

    /**
     * Retrieves statistics related to replication for the Queue service. It is only available on the secondary location endpoint when read-access geo-redundant replication is enabled for the storage account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<ServiceGetStatisticsResponse> getStatisticsWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        final String restype = "service";
        final String comp = "stats";
        return service.getStatistics(context, this.client.url(), timeout, this.client.version(), requestId, restype, comp);
    }

    /**
     * Retrieves statistics related to replication for the Queue service. It is only available on the secondary location endpoint when read-access geo-redundant replication is enabled for the storage account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Maybe<StorageServiceStats> getStatisticsAsync(Context context, Integer timeout, String requestId) {
        return getStatisticsWithRestResponseAsync(context, timeout, requestId)
                .flatMapMaybe((ServiceGetStatisticsResponse res) -> res.body() == null ? Maybe.empty() : Maybe.just(res.body()));
    }

    /**
     * The List Queues Segment operation returns a list of the queues under the specified account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param prefix
     *         Filters the results to return only queues whose name begins with the specified prefix.
     * @param marker
     *         A string value that identifies the portion of the list of queues to be returned with the next listing operation. The operation returns the NextMarker value within the response body if the listing operation did not return all queues remaining to be listed with the current page. The NextMarker value can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
     * @param maxresults
     *         Specifies the maximum number of queues to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or than the default of 5000.
     * @param include
     *         Include this parameter to specify that the queues's metadata be returned as part of the response body.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return the ListQueuesResponse object if successful.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public ListQueuesResponse listQueuesSegment(Context context, String prefix, String marker, Integer maxresults, List<ListQueuesIncludeType> include, Integer timeout, String requestId) {
        return listQueuesSegmentAsync(context, prefix, marker, maxresults, include, timeout, requestId).blockingGet();
    }

    /**
     * The List Queues Segment operation returns a list of the queues under the specified account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param prefix
     *         Filters the results to return only queues whose name begins with the specified prefix.
     * @param marker
     *         A string value that identifies the portion of the list of queues to be returned with the next listing operation. The operation returns the NextMarker value within the response body if the listing operation did not return all queues remaining to be listed with the current page. The NextMarker value can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
     * @param maxresults
     *         Specifies the maximum number of queues to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or than the default of 5000.
     * @param include
     *         Include this parameter to specify that the queues's metadata be returned as part of the response body.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<ListQueuesResponse> listQueuesSegmentAsync(Context context, String prefix, String marker, Integer maxresults, List<ListQueuesIncludeType> include, Integer timeout, String requestId, ServiceCallback<ListQueuesResponse> serviceCallback) {
        return ServiceFuture.fromBody(listQueuesSegmentAsync(context, prefix, marker, maxresults, include, timeout, requestId), serviceCallback);
    }

    /**
     * The List Queues Segment operation returns a list of the queues under the specified account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param prefix
     *         Filters the results to return only queues whose name begins with the specified prefix.
     * @param marker
     *         A string value that identifies the portion of the list of queues to be returned with the next listing operation. The operation returns the NextMarker value within the response body if the listing operation did not return all queues remaining to be listed with the current page. The NextMarker value can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
     * @param maxresults
     *         Specifies the maximum number of queues to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or than the default of 5000.
     * @param include
     *         Include this parameter to specify that the queues's metadata be returned as part of the response body.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<ServiceListQueuesSegmentResponse> listQueuesSegmentWithRestResponseAsync(Context context, String prefix, String marker, Integer maxresults, List<ListQueuesIncludeType> include, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(include);
        final String comp = "list";
        String includeConverted = this.client.serializerAdapter().serializeList(include, CollectionFormat.CSV);
        return service.listQueuesSegment(context, this.client.url(), prefix, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, comp);
    }

    /**
     * The List Queues Segment operation returns a list of the queues under the specified account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param prefix
     *         Filters the results to return only queues whose name begins with the specified prefix.
     * @param marker
     *         A string value that identifies the portion of the list of queues to be returned with the next listing operation. The operation returns the NextMarker value within the response body if the listing operation did not return all queues remaining to be listed with the current page. The NextMarker value can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
     * @param maxresults
     *         Specifies the maximum number of queues to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or than the default of 5000.
     * @param include
     *         Include this parameter to specify that the queues's metadata be returned as part of the response body.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Maybe<ListQueuesResponse> listQueuesSegmentAsync(Context context, String prefix, String marker, Integer maxresults, List<ListQueuesIncludeType> include, Integer timeout, String requestId) {
        return listQueuesSegmentWithRestResponseAsync(context, prefix, marker, maxresults, include, timeout, requestId)
                .flatMapMaybe((ServiceListQueuesSegmentResponse res) -> res.body() == null ? Maybe.empty() : Maybe.just(res.body()));
    }
}
