/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage;

import com.microsoft.azure.storage.queue.implementation.SignedIdentifiersWrapper;
import com.microsoft.azure.storage.queue.models.QueueCreateResponse;
import com.microsoft.azure.storage.queue.models.QueueDeleteResponse;
import com.microsoft.azure.storage.queue.models.QueueGetAccessPolicyResponse;
import com.microsoft.azure.storage.queue.models.QueueGetPropertiesResponse;
import com.microsoft.azure.storage.queue.models.QueueSetAccessPolicyResponse;
import com.microsoft.azure.storage.queue.models.QueueSetMetadataResponse;
import com.microsoft.azure.storage.queue.models.SignedIdentifier;
import com.microsoft.azure.storage.queue.models.StorageErrorException;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.DELETE;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * An instance of this class provides access to all the operations defined in
 * GeneratedQueues.
 */
public final class GeneratedQueues {
    /**
     * The proxy service used to perform REST calls.
     */
    private QueuesService service;

    /**
     * The service client containing this operation class.
     */
    private GeneratedStorageClient client;

    /**
     * Initializes an instance of GeneratedQueues.
     *
     * @param client
     *         the instance of the service client containing this operation class.
     */
    public GeneratedQueues(GeneratedStorageClient client) {
        this.service = RestProxy.create(QueuesService.class, client);
        this.client = client;
    }

    /**
     * The interface defining all the services for GeneratedQueues to be used
     * by the proxy service to perform REST calls.
     */
    @Host("{url}")
    private interface QueuesService {
        @PUT("{queueName}")
        @ExpectedResponses({201, 204})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<QueueCreateResponse> create(Context context, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId);

        @DELETE("{queueName}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<QueueDeleteResponse> delete(Context context, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId);

        @GET("{queueName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<QueueGetPropertiesResponse> getProperties(Context context, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp);

        @PUT("{queueName}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<QueueSetMetadataResponse> setMetadata(Context context, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp);

        @GET("{queueName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<QueueGetAccessPolicyResponse> getAccessPolicy(Context context, @HostParam("url") String url, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp);

        @PUT("{queueName}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<QueueSetAccessPolicyResponse> setAccessPolicy(Context context, @HostParam("url") String url, @BodyParam("application/xml; charset=utf-8") SignedIdentifiersWrapper queueAcl, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId, @QueryParam("comp") String comp);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void create(Context context, Integer timeout, Map<String, String> metadata, String requestId) {
        createAsync(context, timeout, metadata, requestId).blockingAwait();
    }

    /**
     * creates a new queue under the given account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> createAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(createAsync(context, timeout, metadata, requestId), serviceCallback);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<QueueCreateResponse> createWithRestResponseAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        return service.create(context, this.client.url(), timeout, metadata, this.client.version(), requestId);
    }

    /**
     * creates a new queue under the given account.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable createAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId) {
        return createWithRestResponseAsync(context, timeout, metadata, requestId)
                .toCompletable();
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void delete(Context context, Integer timeout, String requestId) {
        deleteAsync(context, timeout, requestId).blockingAwait();
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> deleteAsync(Context context, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(deleteAsync(context, timeout, requestId), serviceCallback);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<QueueDeleteResponse> deleteWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return service.delete(context, this.client.url(), timeout, this.client.version(), requestId);
    }

    /**
     * operation permanently deletes the specified queue.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable deleteAsync(Context context, Integer timeout, String requestId) {
        return deleteWithRestResponseAsync(context, timeout, requestId)
                .toCompletable();
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the queue as name-values pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void getProperties(Context context, Integer timeout, String requestId) {
        getPropertiesAsync(context, timeout, requestId).blockingAwait();
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the queue as name-values pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> getPropertiesAsync(Context context, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(getPropertiesAsync(context, timeout, requestId), serviceCallback);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the queue as name-values pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<QueueGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        final String comp = "metadata";
        return service.getProperties(context, this.client.url(), timeout, this.client.version(), requestId, comp);
    }

    /**
     * Retrieves user-defined metadata and queue properties on the specified queue. Metadata is associated with the queue as name-values pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable getPropertiesAsync(Context context, Integer timeout, String requestId) {
        return getPropertiesWithRestResponseAsync(context, timeout, requestId)
                .toCompletable();
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void setMetadata(Context context, Integer timeout, Map<String, String> metadata, String requestId) {
        setMetadataAsync(context, timeout, metadata, requestId).blockingAwait();
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> setMetadataAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(setMetadataAsync(context, timeout, metadata, requestId), serviceCallback);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<QueueSetMetadataResponse> setMetadataWithRestResponseAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        final String comp = "metadata";
        return service.setMetadata(context, this.client.url(), timeout, metadata, this.client.version(), requestId, comp);
    }

    /**
     * sets user-defined metadata on the specified queue. Metadata is associated with the queue as name-value pairs.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param metadata
     *         Optional. Include this parameter to specify that the queue's metadata be returned as part of the response body. Note that metadata requested with this parameter must be stored in accordance with the naming restrictions imposed by the 2009-09-19 version of the Queue service. Beginning with this version, all metadata names must adhere to the naming conventions for C# identifiers.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable setMetadataAsync(Context context, Integer timeout, Map<String, String> metadata, String requestId) {
        return setMetadataWithRestResponseAsync(context, timeout, metadata, requestId)
                .toCompletable();
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return the List&lt;SignedIdentifier&gt; object if successful.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public List<SignedIdentifier> getAccessPolicy(Context context, Integer timeout, String requestId) {
        return getAccessPolicyAsync(context, timeout, requestId).blockingGet();
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<List<SignedIdentifier>> getAccessPolicyAsync(Context context, Integer timeout, String requestId, ServiceCallback<List<SignedIdentifier>> serviceCallback) {
        return ServiceFuture.fromBody(getAccessPolicyAsync(context, timeout, requestId), serviceCallback);
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<QueueGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        final String comp = "acl";
        return service.getAccessPolicy(context, this.client.url(), timeout, this.client.version(), requestId, comp);
    }

    /**
     * returns details about any stored access policies specified on the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Maybe<List<SignedIdentifier>> getAccessPolicyAsync(Context context, Integer timeout, String requestId) {
        return getAccessPolicyWithRestResponseAsync(context, timeout, requestId)
                .flatMapMaybe((QueueGetAccessPolicyResponse res) -> res.body() == null ? Maybe.empty() : Maybe.just(res.body()));
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueAcl
     *         the acls for the queue.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void setAccessPolicy(Context context, List<SignedIdentifier> queueAcl, Integer timeout, String requestId) {
        setAccessPolicyAsync(context, queueAcl, timeout, requestId).blockingAwait();
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueAcl
     *         the acls for the queue.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> setAccessPolicyAsync(Context context, List<SignedIdentifier> queueAcl, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(setAccessPolicyAsync(context, queueAcl, timeout, requestId), serviceCallback);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueAcl
     *         the acls for the queue.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<QueueSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(Context context, List<SignedIdentifier> queueAcl, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(queueAcl);
        final String comp = "acl";
        return service.setAccessPolicy(context, this.client.url(), new SignedIdentifiersWrapper(queueAcl), timeout, this.client.version(), requestId, comp);
    }

    /**
     * sets stored access policies for the queue that may be used with Shared Access Signatures.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueAcl
     *         the acls for the queue.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable setAccessPolicyAsync(Context context, List<SignedIdentifier> queueAcl, Integer timeout, String requestId) {
        return setAccessPolicyWithRestResponseAsync(context, queueAcl, timeout, requestId)
                .toCompletable();
    }
}
