/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 * <p>
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage;

import com.microsoft.azure.storage.queue.models.MessageIDDeleteResponse;
import com.microsoft.azure.storage.queue.models.MessageIDUpdateResponse;
import com.microsoft.azure.storage.queue.models.QueueMessage;
import com.microsoft.azure.storage.queue.models.StorageErrorException;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.DELETE;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;

/**
 * An instance of this class provides access to all the operations defined in
 * GeneratedMessageIDs.
 */
public final class GeneratedMessageIDs {
    /**
     * The proxy service used to perform REST calls.
     */
    private MessageIDsService service;

    /**
     * The service client containing this operation class.
     */
    private GeneratedStorageClient client;

    /**
     * Initializes an instance of GeneratedMessageIDs.
     *
     * @param client
     *         the instance of the service client containing this operation class.
     */
    public GeneratedMessageIDs(GeneratedStorageClient client) {
        this.service = RestProxy.create(MessageIDsService.class, client);
        this.client = client;
    }

    /**
     * The interface defining all the services for GeneratedMessageIDs to be
     * used by the proxy service to perform REST calls.
     */
    @Host("{url}")
    private interface MessageIDsService {
        @PUT("{queueName}/messages/{messageid}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<MessageIDUpdateResponse> update(Context context, @HostParam("url") String url, @BodyParam("application/xml; charset=utf-8") QueueMessage queueMessage, @QueryParam("popreceipt") String popReceipt, @QueryParam("visibilitytimeout") int visibilitytimeout, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId);

        @DELETE("{queueName}/messages/{messageid}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(StorageErrorException.class)
        Single<MessageIDDeleteResponse> delete(Context context, @HostParam("url") String url, @QueryParam("popreceipt") String popReceipt, @QueryParam("timeout") Integer timeout, @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId);
    }

    /**
     * The Update operation was introduced with version 2011-08-18 of the Queue service API. The Update Message operation updates the visibility timeout of a message. You can also use this operation to update the contents of a message. A message must be in a format that can be included in an XML request with UTF-8 encoding, and the encoded message can be up to 64KB in size.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueMessage
     *         A Message object which can be stored in a Queue.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param visibilitytimeout
     *         Optional. Specifies the new visibility timeout value, in seconds, relative to server time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void update(Context context, @NonNull QueueMessage queueMessage, @NonNull String popReceipt, @NonNull int visibilitytimeout, Integer timeout, String requestId) {
        updateAsync(context, queueMessage, popReceipt, visibilitytimeout, timeout, requestId).blockingAwait();
    }

    /**
     * The Update operation was introduced with version 2011-08-18 of the Queue service API. The Update Message operation updates the visibility timeout of a message. You can also use this operation to update the contents of a message. A message must be in a format that can be included in an XML request with UTF-8 encoding, and the encoded message can be up to 64KB in size.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueMessage
     *         A Message object which can be stored in a Queue.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param visibilitytimeout
     *         Optional. Specifies the new visibility timeout value, in seconds, relative to server time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> updateAsync(Context context, @NonNull QueueMessage queueMessage, @NonNull String popReceipt, @NonNull int visibilitytimeout, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(updateAsync(context, queueMessage, popReceipt, visibilitytimeout, timeout, requestId), serviceCallback);
    }

    /**
     * The Update operation was introduced with version 2011-08-18 of the Queue service API. The Update Message operation updates the visibility timeout of a message. You can also use this operation to update the contents of a message. A message must be in a format that can be included in an XML request with UTF-8 encoding, and the encoded message can be up to 64KB in size.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueMessage
     *         A Message object which can be stored in a Queue.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param visibilitytimeout
     *         Optional. Specifies the new visibility timeout value, in seconds, relative to server time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<MessageIDUpdateResponse> updateWithRestResponseAsync(Context context, @NonNull QueueMessage queueMessage, @NonNull String popReceipt, @NonNull int visibilitytimeout, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (queueMessage == null) {
            throw new IllegalArgumentException("Parameter queueMessage is required and cannot be null.");
        }
        if (popReceipt == null) {
            throw new IllegalArgumentException("Parameter popReceipt is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(queueMessage);
        return service.update(context, this.client.url(), queueMessage, popReceipt, visibilitytimeout, timeout, this.client.version(), requestId);
    }

    /**
     * The Update operation was introduced with version 2011-08-18 of the Queue service API. The Update Message operation updates the visibility timeout of a message. You can also use this operation to update the contents of a message. A message must be in a format that can be included in an XML request with UTF-8 encoding, and the encoded message can be up to 64KB in size.
     *
     * @param context
     *         The context to associate with this operation.
     * @param queueMessage
     *         A Message object which can be stored in a Queue.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param visibilitytimeout
     *         Optional. Specifies the new visibility timeout value, in seconds, relative to server time. The default value is 30 seconds. A specified value must be larger than or equal to 1 second, and cannot be larger than 7 days, or larger than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility timeout of a message can be set to a value later than the expiry time.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable updateAsync(Context context, @NonNull QueueMessage queueMessage, @NonNull String popReceipt, @NonNull int visibilitytimeout, Integer timeout, String requestId) {
        return updateWithRestResponseAsync(context, queueMessage, popReceipt, visibilitytimeout, timeout, requestId)
                .toCompletable();
    }

    /**
     * The Delete operation deletes the specified message.
     *
     * @param context
     *         The context to associate with this operation.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     * @throws StorageErrorException
     *         thrown if the request is rejected by server.
     * @throws RuntimeException
     *         all other wrapped checked exceptions if the request fails to be sent.
     */
    public void delete(Context context, @NonNull String popReceipt, Integer timeout, String requestId) {
        deleteAsync(context, popReceipt, timeout, requestId).blockingAwait();
    }

    /**
     * The Delete operation deletes the specified message.
     *
     * @param context
     *         The context to associate with this operation.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     * @param serviceCallback
     *         the async ServiceCallback to handle successful and failed responses.
     *
     * @return a ServiceFuture which will be completed with the result of the network request.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public ServiceFuture<Void> deleteAsync(Context context, @NonNull String popReceipt, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody(deleteAsync(context, popReceipt, timeout, requestId), serviceCallback);
    }

    /**
     * The Delete operation deletes the specified message.
     *
     * @param context
     *         The context to associate with this operation.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Single<MessageIDDeleteResponse> deleteWithRestResponseAsync(Context context, @NonNull String popReceipt, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (popReceipt == null) {
            throw new IllegalArgumentException("Parameter popReceipt is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return service.delete(context, this.client.url(), popReceipt, timeout, this.client.version(), requestId);
    }

    /**
     * The Delete operation deletes the specified message.
     *
     * @param context
     *         The context to associate with this operation.
     * @param popReceipt
     *         Required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or Update Message operation.
     * @param timeout
     *         The The timeout parameter is expressed in seconds. For more information, see &lt;a href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations&gt;Setting Timeouts for Queue Service Operations.&lt;/a&gt;.
     * @param requestId
     *         Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
     *
     * @return a Single which performs the network request upon subscription.
     *
     * @throws IllegalArgumentException
     *         thrown if parameters fail the validation.
     */
    public Completable deleteAsync(Context context, @NonNull String popReceipt, Integer timeout, String requestId) {
        return deleteWithRestResponseAsync(context, popReceipt, timeout, requestId)
                .toCompletable();
    }
}
